/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.executor;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskLogMarkers;
import org.apache.dolphinscheduler.plugin.task.api.model.ApplicationInfo;
import org.apache.dolphinscheduler.plugin.task.api.resource.ResourceContext;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutorBuilder;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskPluginFactory;
import org.apache.dolphinscheduler.server.worker.utils.TaskExecutionContextUtils;
import org.apache.dolphinscheduler.server.worker.utils.TenantUtils;
import org.apache.dolphinscheduler.task.executor.AbstractTaskExecutor;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.TaskExecutorState;
import org.apache.dolphinscheduler.task.executor.TaskExecutorStateMappings;
import org.apache.dolphinscheduler.task.executor.events.AbstractTaskExecutorLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorRuntimeContextChangedLifecycleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalTaskExecutor
extends AbstractTaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhysicalTaskExecutor.class);
    private final WorkerConfig workerConfig;
    private final StorageOperator storageOperator;
    private AbstractTask physicalTask;
    private final PhysicalTaskPluginFactory physicalTaskPluginFactory;

    public PhysicalTaskExecutor(PhysicalTaskExecutorBuilder physicalTaskExecutorBuilder) {
        super(physicalTaskExecutorBuilder.getTaskExecutionContext(), physicalTaskExecutorBuilder.getTaskExecutorEventBus());
        this.workerConfig = physicalTaskExecutorBuilder.getWorkerConfig();
        this.storageOperator = physicalTaskExecutorBuilder.getStorageOperator();
        this.physicalTaskPluginFactory = physicalTaskExecutorBuilder.getPhysicalTaskPluginFactory();
    }

    protected void initializeTaskPlugin() {
        this.physicalTask = this.physicalTaskPluginFactory.createPhysicalTask(this);
        log.info("Initialized physicalTask: {} successfully", (Object)this.taskExecutionContext.getTaskType());
        this.physicalTask.init();
        this.physicalTask.getParameters().setVarPool(new ArrayList());
        log.info("Set taskVarPool: {} successfully", (Object)this.taskExecutionContext.getVarPool());
    }

    protected void doTriggerTaskPlugin() {
        PhysicalTaskExecutor taskExecutor = this;
        this.physicalTask.handle(new TaskCallBack((ITaskExecutor)taskExecutor){
            final /* synthetic */ ITaskExecutor val$taskExecutor;
            {
                this.val$taskExecutor = iTaskExecutor;
            }

            public void updateRemoteApplicationInfo(int taskInstanceId, ApplicationInfo applicationInfo) {
                PhysicalTaskExecutor.this.taskExecutionContext.setAppIds(applicationInfo.getAppIds());
                PhysicalTaskExecutor.this.taskExecutorEventBus.publish((AbstractTaskExecutorLifecycleEvent)TaskExecutorRuntimeContextChangedLifecycleEvent.of((ITaskExecutor)this.val$taskExecutor));
            }

            public void updateTaskInstanceInfo(int taskInstanceId) {
                PhysicalTaskExecutor.this.taskExecutorEventBus.publish((AbstractTaskExecutorLifecycleEvent)TaskExecutorRuntimeContextChangedLifecycleEvent.of((ITaskExecutor)this.val$taskExecutor));
            }
        });
    }

    protected TaskExecutorState doTrackTaskPluginStatus() {
        return TaskExecutorStateMappings.mapState((TaskExecutionStatus)this.physicalTask.getExitStatus());
    }

    public void pause() {
        log.warn("The physical doesn't support pause");
    }

    public void kill() {
        if (this.physicalTask != null) {
            this.physicalTask.cancel();
        }
    }

    public void finalizeTask() {
        this.clearTaskInstanceWorkingDirectoryIfNeeded();
    }

    private void clearTaskInstanceWorkingDirectoryIfNeeded() {
        boolean isDevelopment = PropertyUtils.getBoolean((String)"development.state", (Boolean)true);
        if (!isDevelopment) {
            TaskExecutionContextUtils.clearTaskInstanceWorkingDirectory(this.taskExecutionContext);
        }
    }

    protected void initializeTaskContext() {
        super.initializeTaskContext();
        this.taskExecutionContext.setTaskAppId(String.valueOf(this.taskExecutionContext.getTaskInstanceId()));
        this.taskExecutionContext.setTenantCode(TenantUtils.getOrCreateActualTenant(this.workerConfig, this.taskExecutionContext));
        log.info("TenantCode: {} check successfully", (Object)this.taskExecutionContext.getTenantCode());
        TaskExecutionContextUtils.createTaskInstanceWorkingDirectory(this.taskExecutionContext);
        log.info("TaskInstance working directory: {} create successfully", (Object)this.taskExecutionContext.getExecutePath());
        ResourceContext resourceContext = TaskExecutionContextUtils.downloadResourcesIfNeeded(this.physicalTaskPluginFactory.getTaskChannel(this), this.storageOperator, this.taskExecutionContext);
        this.taskExecutionContext.setResourceContext(resourceContext);
        log.info("Download resources successfully: \n{}", (Object)this.taskExecutionContext.getResourceContext());
        log.info(TaskLogMarkers.excludeInTaskLog(), "Initialized Task Context{}", (Object)JSONUtils.toPrettyJsonString((Object)this.taskExecutionContext));
    }

    public String toString() {
        return "PhysicalTaskExecutor{id=" + this.taskExecutionContext.getTaskInstanceId() + ", name=" + this.taskExecutionContext.getTaskName() + ", stat=" + this.taskExecutorState.get() + '}';
    }

    @Generated
    public AbstractTask getPhysicalTask() {
        return this.physicalTask;
    }
}

