/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class TaskFilesTransferUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskFilesTransferUtils.class);
    static final String DOWNLOAD_TMP = ".DT_TMP";
    static final String PACK_SUFFIX = "_ds_pack.zip";
    static final String RESOURCE_TAG = "DATA_TRANSFER";

    private TaskFilesTransferUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void uploadOutputFiles(TaskExecutionContext taskExecutionContext, StorageOperator storageOperator) throws TaskException {
        List<Property> localParamsProperty = TaskFilesTransferUtils.getFileLocalParams(taskExecutionContext, Direct.OUT);
        if (localParamsProperty.isEmpty()) {
            return;
        }
        List<Property> varPools = TaskFilesTransferUtils.getVarPools(taskExecutionContext);
        Map<String, Property> varPoolsMap = varPools.stream().filter(property -> Direct.OUT.equals((Object)property.getDirect())).collect(Collectors.toMap(Property::getProp, x -> x));
        log.info("Upload output files ...");
        for (Property property2 : localParamsProperty) {
            Property oriProperty;
            String path = String.format("%s/%s", taskExecutionContext.getExecutePath(), property2.getValue());
            String srcPath = TaskFilesTransferUtils.packIfDir(path);
            String srcCRCPath = srcPath + ".crc";
            try {
                org.apache.dolphinscheduler.common.utils.FileUtils.writeContent2File((String)org.apache.dolphinscheduler.common.utils.FileUtils.getFileChecksum((String)path), (String)srcCRCPath);
            }
            catch (IOException ex) {
                throw new TaskException(ex.getMessage(), (Throwable)ex);
            }
            String resourcePath = TaskFilesTransferUtils.getResourcePath(taskExecutionContext, new File(srcPath).getName());
            String resourceCRCPath = resourcePath + ".crc";
            try {
                String resourceWholePath = storageOperator.getStorageFileAbsolutePath(taskExecutionContext.getTenantCode(), resourcePath);
                String resourceCRCWholePath = storageOperator.getStorageFileAbsolutePath(taskExecutionContext.getTenantCode(), resourceCRCPath);
                log.info("{} --- Local:{} to Remote:{}", new Object[]{property2, srcPath, resourceWholePath});
                storageOperator.upload(srcPath, resourceWholePath, false, true);
                log.info("{} --- Local:{} to Remote:{}", new Object[]{"CRC file", srcCRCPath, resourceCRCWholePath});
                storageOperator.upload(srcCRCPath, resourceCRCWholePath, false, true);
            }
            catch (Exception ex) {
                throw new TaskException("Upload file to storage error", (Throwable)ex);
            }
            if (varPoolsMap.containsKey(property2.getProp())) {
                oriProperty = varPoolsMap.get(property2.getProp());
            } else {
                oriProperty = new Property(property2.getProp(), Direct.OUT, DataType.FILE, property2.getValue());
                varPools.add(oriProperty);
            }
            oriProperty.setProp(String.format("%s.%s", taskExecutionContext.getTaskName(), oriProperty.getProp()));
            oriProperty.setValue(resourcePath);
        }
        taskExecutionContext.setVarPool(JSONUtils.toJsonString(varPools));
    }

    public static void downloadUpstreamFiles(TaskExecutionContext taskExecutionContext, StorageOperator storageOperator) {
        List<Property> localParamsProperty = TaskFilesTransferUtils.getFileLocalParams(taskExecutionContext, Direct.IN);
        if (localParamsProperty.isEmpty()) {
            return;
        }
        List<Property> varPools = TaskFilesTransferUtils.getVarPools(taskExecutionContext);
        Map<String, Property> varPoolsMap = varPools.stream().filter(property -> Direct.IN.equals((Object)property.getDirect())).collect(Collectors.toMap(Property::getProp, x -> x));
        String executePath = taskExecutionContext.getExecutePath();
        String downloadTmpPath = String.format("%s/%s", executePath, DOWNLOAD_TMP);
        log.info("Download upstream files...");
        for (Property property2 : localParamsProperty) {
            Property inVarPool = varPoolsMap.get(property2.getValue());
            if (inVarPool == null) {
                log.error("{} not in  {}", (Object)property2.getValue(), varPoolsMap.keySet());
                throw new TaskException(String.format("Can not find upstream file using %s, please check the key", property2.getValue()));
            }
            String resourcePath = inVarPool.getValue();
            String targetPath = String.format("%s/%s", executePath, property2.getProp());
            boolean isPack = resourcePath.endsWith(PACK_SUFFIX);
            String downloadPath = isPack ? String.format("%s/%s", downloadTmpPath, new File(resourcePath).getName()) : targetPath;
            String resourceWholePath = storageOperator.getStorageFileAbsolutePath(taskExecutionContext.getTenantCode(), resourcePath);
            log.info("{} --- Remote:{} to Local:{}", new Object[]{property2, resourceWholePath, downloadPath});
            storageOperator.download(resourceWholePath, downloadPath, true);
            if (!isPack) continue;
            File downloadFile = new File(downloadPath);
            log.info("Unpack {} to {}", (Object)downloadPath, (Object)targetPath);
            ZipUtil.unpack((File)downloadFile, (File)new File(targetPath));
        }
        try {
            FileUtils.deleteDirectory((File)new File(downloadTmpPath));
        }
        catch (IOException e) {
            log.error("Delete DownloadTmpPath {} failed, this will not affect the task status", (Object)downloadTmpPath, (Object)e);
        }
    }

    public static List<Property> getFileLocalParams(TaskExecutionContext taskExecutionContext, Direct direct) {
        ArrayList<Property> localParamsProperty = new ArrayList<Property>();
        ObjectNode taskParams = JSONUtils.parseObject((String)taskExecutionContext.getTaskParams());
        for (JsonNode localParam : taskParams.get("localParams")) {
            Property property = (Property)JSONUtils.parseObject((String)localParam.toString(), Property.class);
            if (!property.getDirect().equals((Object)direct) || !property.getType().equals((Object)DataType.FILE)) continue;
            localParamsProperty.add(property);
        }
        return localParamsProperty;
    }

    public static String getResourcePath(TaskExecutionContext taskExecutionContext, String fileName) {
        String date = DateUtils.formatTimeStamp((long)taskExecutionContext.getEndTime(), (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyyMMdd"));
        String resourceFolder = String.format("%s/%s/%d/%d_%d", RESOURCE_TAG, date, taskExecutionContext.getWorkflowDefinitionCode(), taskExecutionContext.getWorkflowDefinitionVersion(), taskExecutionContext.getWorkflowInstanceId());
        return String.format("%s/%s_%s_%s", resourceFolder, taskExecutionContext.getTaskName().replace(" ", "_"), taskExecutionContext.getTaskInstanceId(), fileName);
    }

    public static List<Property> getVarPools(TaskExecutionContext taskExecutionContext) {
        ArrayList<Property> varPools = new ArrayList<Property>();
        String varPoolString = taskExecutionContext.getVarPool();
        if (StringUtils.isEmpty((CharSequence)varPoolString)) {
            return varPools;
        }
        for (JsonNode varPoolData : JSONUtils.parseArray((String)varPoolString)) {
            Property property = (Property)JSONUtils.parseObject((String)varPoolData.toString(), Property.class);
            varPools.add(property);
        }
        return varPools;
    }

    public static String packIfDir(String path) throws TaskException {
        String newPath;
        File file = new File(path);
        if (!file.exists()) {
            throw new TaskException(String.format("%s dose not exists", path));
        }
        if (file.isDirectory()) {
            newPath = file.getPath() + PACK_SUFFIX;
            log.info("Pack {} to {}", (Object)path, (Object)newPath);
            ZipUtil.pack((File)file, (File)new File(newPath));
        } else {
            newPath = path;
        }
        return newPath;
    }
}

