/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceClientProvider;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceProcessorProvider;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.SQLTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskConstants;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.SqlType;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskAlertInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SqlParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.sql.SqlBinds;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlTask.class);
    private final TaskExecutionContext taskExecutionContext;
    private final SqlParameters sqlParameters;
    private BaseConnectionParam baseConnectionParam;
    private static final String CREATE_OR_REPLACE_FUNCTION_FORMAT = "create or replace temporary function {0} as ''{1}''";
    private static final int QUERY_LIMIT = 10000;
    private SQLTaskExecutionContext sqlTaskExecutionContext;
    public static final int TEST_FLAG_YES = 1;
    private final DbType dbType;

    public SqlTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.taskExecutionContext = taskRequest;
        this.sqlParameters = (SqlParameters)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), SqlParameters.class);
        log.info("Initialize sql task parameter {}", (Object)JSONUtils.toPrettyJsonString((Object)this.sqlParameters));
        if (this.sqlParameters == null || !this.sqlParameters.checkParameters()) {
            throw new TaskException("sql task params is not valid");
        }
        if (this.sqlParameters.getDatasource() == 0) {
            throw new TaskException("unbound test data source");
        }
        this.sqlTaskExecutionContext = this.sqlParameters.generateExtendedContext(this.taskExecutionContext.getResourceParametersHelper());
        this.dbType = DbType.valueOf((String)this.sqlParameters.getType());
    }

    public AbstractParameters getParameters() {
        return this.sqlParameters;
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        log.info("Full sql parameters: {}", (Object)this.sqlParameters);
        log.info("sql type : {}, datasource : {}, sql : {} , localParams : {},showType : {},connParams : {},varPool : {} ,query max result limit  {}", new Object[]{this.sqlParameters.getType(), this.sqlParameters.getDatasource(), this.sqlParameters.getSql(), this.sqlParameters.getLocalParams(), this.sqlParameters.getShowType(), this.sqlParameters.getConnParams(), this.sqlParameters.getVarPool(), this.sqlParameters.getLimit()});
        try {
            this.baseConnectionParam = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)this.dbType, (String)this.sqlTaskExecutionContext.getConnectionParams());
            List subSqls = DataSourceProcessorProvider.getDataSourceProcessor((DbType)this.dbType).splitAndRemoveComment(this.sqlParameters.getSql());
            List<SqlBinds> mainStatementSqlBinds = subSqls.stream().map(this::getSqlAndSqlParamsMap).collect(Collectors.toList());
            List<SqlBinds> preStatementSqlBinds = ((List)Optional.ofNullable(this.sqlParameters.getPreStatements()).orElse(new ArrayList())).stream().map(this::getSqlAndSqlParamsMap).collect(Collectors.toList());
            List<SqlBinds> postStatementSqlBinds = ((List)Optional.ofNullable(this.sqlParameters.getPostStatements()).orElse(new ArrayList())).stream().map(this::getSqlAndSqlParamsMap).collect(Collectors.toList());
            this.executeFuncAndSql(mainStatementSqlBinds, preStatementSqlBinds, postStatementSqlBinds);
            this.setExitStatusCode(0);
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            log.error("sql task error", (Throwable)e);
            throw new TaskException("Execute sql task failed", (Throwable)e);
        }
    }

    public void cancel() throws TaskException {
    }

    public void executeFuncAndSql(List<SqlBinds> mainStatementsBinds, List<SqlBinds> preStatementsBinds, List<SqlBinds> postStatementsBinds) throws Exception {
        try (Connection connection = DataSourceClientProvider.getAdHocConnection((DbType)DbType.valueOf((String)this.sqlParameters.getType()), (ConnectionParam)this.baseConnectionParam);){
            this.executeUpdate(connection, preStatementsBinds, "pre");
            String result = null;
            if (this.sqlParameters.getSqlType() == SqlType.QUERY.ordinal()) {
                result = this.executeQuery(connection, mainStatementsBinds.get(0), "main");
            } else if (this.sqlParameters.getSqlType() == SqlType.NON_QUERY.ordinal()) {
                String updateResult = this.executeUpdate(connection, mainStatementsBinds, "main");
                result = this.setNonQuerySqlReturn(updateResult, this.sqlParameters.getLocalParams());
            }
            this.sqlParameters.dealOutParam(result);
            this.executeUpdate(connection, postStatementsBinds, "post");
        }
        catch (Exception e) {
            log.error("execute sql error: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private String setNonQuerySqlReturn(String updateResult, List<Property> properties) {
        String result = null;
        for (Property info : properties) {
            if (Direct.OUT != info.getDirect()) continue;
            ArrayList updateRL = new ArrayList();
            HashMap<String, String> updateRM = new HashMap<String, String>();
            updateRM.put(info.getProp(), updateResult);
            updateRL.add(updateRM);
            result = JSONUtils.toJsonString(updateRL);
            break;
        }
        return result;
    }

    private String resultProcess(ResultSet resultSet) throws Exception {
        String result;
        ArrayNode resultJSONArray = JSONUtils.createArrayNode();
        if (resultSet != null) {
            int i;
            ResultSetMetaData md = resultSet.getMetaData();
            int num = md.getColumnCount();
            while (resultSet.next()) {
                ObjectNode mapOfColValues = JSONUtils.createObjectNode();
                for (i = 1; i <= num; ++i) {
                    mapOfColValues.set(md.getColumnLabel(i), JSONUtils.toJsonNode((Object)resultSet.getObject(i)));
                }
                resultJSONArray.add((JsonNode)mapOfColValues);
            }
            int displayRows = this.sqlParameters.getDisplayRows() > 0 ? this.sqlParameters.getDisplayRows() : 10;
            displayRows = Math.min(displayRows, resultJSONArray.size());
            log.info("display sql result {} rows as follows:", (Object)displayRows);
            for (i = 0; i < displayRows; ++i) {
                String row = JSONUtils.toJsonString((Object)resultJSONArray.get(i));
                log.info("row {} : {}", (Object)(i + 1), (Object)row);
            }
        }
        String string = result = resultJSONArray.isEmpty() ? JSONUtils.toJsonString((Object)this.generateEmptyRow(resultSet)) : JSONUtils.toJsonString((Object)resultJSONArray);
        if (Boolean.TRUE.equals(this.sqlParameters.getSendEmail())) {
            this.sendAttachment(this.sqlParameters.getGroupId(), StringUtils.isNotEmpty((CharSequence)this.sqlParameters.getTitle()) ? this.sqlParameters.getTitle() : this.taskExecutionContext.getTaskName() + " query result sets", result);
        }
        log.debug("execute sql result : {}", (Object)result);
        return result;
    }

    private ArrayNode generateEmptyRow(ResultSet resultSet) throws SQLException {
        ArrayNode resultJSONArray = JSONUtils.createArrayNode();
        ObjectNode emptyOfColValues = JSONUtils.createObjectNode();
        if (resultSet != null) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnsNum = metaData.getColumnCount();
            log.info("sql query results is empty");
            for (int i = 1; i <= columnsNum; ++i) {
                emptyOfColValues.set(metaData.getColumnLabel(i), JSONUtils.toJsonNode((Object)""));
            }
        } else {
            emptyOfColValues.set("error", JSONUtils.toJsonNode((Object)"resultSet is null"));
        }
        resultJSONArray.add((JsonNode)emptyOfColValues);
        return resultJSONArray;
    }

    private void sendAttachment(int groupId, String title, String content) {
        this.setNeedAlert(Boolean.TRUE);
        TaskAlertInfo taskAlertInfo = new TaskAlertInfo();
        taskAlertInfo.setAlertGroupId(Integer.valueOf(groupId));
        taskAlertInfo.setContent(content);
        taskAlertInfo.setTitle(title);
        this.setTaskAlertInfo(taskAlertInfo);
    }

    private String executeQuery(Connection connection, SqlBinds sqlBinds, String handlerType) throws Exception {
        try (PreparedStatement statement = this.prepareStatementAndBind(connection, sqlBinds);){
            log.info("{} statement execute query, for sql: {}", (Object)handlerType, (Object)sqlBinds.getSql());
            ResultSet resultSet = statement.executeQuery();
            String string = this.resultProcess(resultSet);
            return string;
        }
    }

    private String executeUpdate(Connection connection, List<SqlBinds> statementsBinds, String handlerType) throws Exception {
        int result = 0;
        for (SqlBinds sqlBind : statementsBinds) {
            PreparedStatement statement = this.prepareStatementAndBind(connection, sqlBind);
            Throwable throwable = null;
            try {
                result = statement.executeUpdate();
                log.info("{} statement execute update result: {}, for sql: {}", new Object[]{handlerType, result, sqlBind.getSql()});
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                statement.close();
            }
        }
        return String.valueOf(result);
    }

    private void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error("close connection error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private PreparedStatement prepareStatementAndBind(Connection connection, SqlBinds sqlBinds) {
        boolean timeoutFlag = this.taskExecutionContext.getTaskTimeoutStrategy() == TaskTimeoutStrategy.FAILED || this.taskExecutionContext.getTaskTimeoutStrategy() == TaskTimeoutStrategy.WARNFAILED;
        try {
            PreparedStatement stmt = connection.prepareStatement(sqlBinds.getSql());
            if (timeoutFlag) {
                stmt.setQueryTimeout(this.taskExecutionContext.getTaskTimeout());
            }
            stmt.setMaxRows(this.sqlParameters.getLimit() <= 0 ? 10000 : this.sqlParameters.getLimit());
            Map<Integer, Property> params = sqlBinds.getParamsMap();
            if (params != null) {
                for (Map.Entry<Integer, Property> entry : params.entrySet()) {
                    Property prop = entry.getValue();
                    ParameterUtils.setInParameter((int)entry.getKey(), (PreparedStatement)stmt, (DataType)prop.getType(), (String)prop.getValue());
                }
            }
            log.info("prepare statement replace sql : {}, sql parameters : {}", (Object)sqlBinds.getSql(), sqlBinds.getParamsMap());
            return stmt;
        }
        catch (Exception exception) {
            throw new TaskException("SQL task prepareStatementAndBind error", (Throwable)exception);
        }
    }

    private void printReplacedSql(String content, String formatSql, String rgex, Map<Integer, Property> sqlParamsMap) {
        log.info("after replace sql , preparing : {}", (Object)formatSql);
        StringBuilder logPrint = new StringBuilder("replaced sql , parameters:");
        if (sqlParamsMap == null) {
            log.info("printReplacedSql: sqlParamsMap is null.");
        } else {
            for (int i = 1; i <= sqlParamsMap.size(); ++i) {
                logPrint.append(sqlParamsMap.get(i).getValue()).append("(").append(sqlParamsMap.get(i).getType()).append(")");
            }
        }
        log.info("Sql Params are {}", (Object)logPrint);
    }

    private SqlBinds getSqlAndSqlParamsMap(String sql) {
        HashMap<Integer, Property> sqlParamsMap = new HashMap<Integer, Property>();
        StringBuilder sqlBuilder = new StringBuilder();
        sql = ParameterUtils.replaceScheduleTime((String)sql, (Date)DateUtils.timeStampToDate((long)this.taskExecutionContext.getScheduleTime()));
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        if (paramsMap == null) {
            sqlBuilder.append(sql);
            return new SqlBinds(sqlBuilder.toString(), sqlParamsMap);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.sqlParameters.getTitle())) {
            String title = ParameterUtils.convertParameterPlaceholders((String)this.sqlParameters.getTitle(), (Map)ParameterUtils.convert((Map)paramsMap));
            log.info("SQL title : {}", (Object)title);
            this.sqlParameters.setTitle(title);
        }
        this.setSqlParamsMap(sql, sqlParamsMap, paramsMap, this.taskExecutionContext.getTaskInstanceId());
        String rgexo = "['\"]*\\!\\{(.*?)\\}['\"]*";
        sql = this.replaceOriginalValue(sql, rgexo, paramsMap);
        String formatSql = ParameterUtils.expandListParameter(sqlParamsMap, (String)sql);
        sqlBuilder.append(formatSql);
        this.printReplacedSql(sql, formatSql, TaskConstants.SQL_PARAMS_REGEX, sqlParamsMap);
        return new SqlBinds(sqlBuilder.toString(), sqlParamsMap);
    }

    private String replaceOriginalValue(String content, String rgex, Map<String, Property> sqlParamsMap) {
        Matcher m;
        Pattern pattern = Pattern.compile(rgex);
        while ((m = pattern.matcher(content)).find()) {
            String paramName = m.group(1);
            String paramValue = sqlParamsMap.get(paramName).getValue();
            content = m.replaceFirst(paramValue);
        }
        return content;
    }
}

