/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.python;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.shell.ShellInterceptorBuilderFactory;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.python.PythonParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PythonTask.class);
    protected PythonParameters pythonParameters;
    private ShellCommandExecutor shellCommandExecutor;
    protected TaskExecutionContext taskRequest;
    protected static final String PYTHON_LAUNCHER = "PYTHON_LAUNCHER";

    public PythonTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.taskRequest = taskRequest;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((PythonTask)this).logHandle(arg_0), taskRequest);
    }

    public void init() {
        this.pythonParameters = (PythonParameters)((Object)JSONUtils.parseObject((String)this.taskRequest.getTaskParams(), PythonParameters.class));
        log.info("Initialize python task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.pythonParameters)));
        if (this.pythonParameters == null || !this.pythonParameters.checkParameters()) {
            throw new TaskException("python task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String pythonScriptContent = this.buildPythonScriptContent();
            String pythonScriptFile = this.buildPythonCommandFilePath();
            this.createPythonCommandFileIfNotExists(pythonScriptContent, pythonScriptFile);
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().appendScript(this.buildPythonExecuteCommand(pythonScriptFile));
            TaskResponse taskResponse = this.shellCommandExecutor.run(shellActuatorBuilder, taskCallBack);
            this.setExitStatusCode(taskResponse.getExitStatusCode());
            this.setProcessId(taskResponse.getProcessId());
            this.setTaskOutputParams(this.shellCommandExecutor.getTaskOutputParams());
            this.pythonParameters.dealOutParam(this.shellCommandExecutor.getTaskOutputParams());
        }
        catch (Exception e) {
            log.error("python task failure", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("run python task error", (Throwable)e);
        }
    }

    public void cancel() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    public AbstractParameters getParameters() {
        return this.pythonParameters;
    }

    protected void createPythonCommandFileIfNotExists(String pythonScript, String pythonScriptFile) throws IOException {
        log.info("tenantCode :{}, task dir:{}", (Object)this.taskRequest.getTenantCode(), (Object)this.taskRequest.getExecutePath());
        if (!Files.exists(Paths.get(pythonScriptFile, new String[0]), new LinkOption[0])) {
            log.info("generate python script file:{}", (Object)pythonScriptFile);
            StringBuilder sb = new StringBuilder();
            sb.append("#-*- encoding=utf8 -*-").append(System.lineSeparator());
            sb.append(System.lineSeparator());
            sb.append(pythonScript);
            log.info(sb.toString());
            FileUtils.writeStringToFile((File)new File(pythonScriptFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }

    protected String buildPythonCommandFilePath() {
        return String.format("%s/py_%s.py", this.taskRequest.getExecutePath(), this.taskRequest.getTaskAppId());
    }

    protected String buildPythonScriptContent() {
        log.info("raw python script : {}", (Object)this.pythonParameters.getRawScript());
        String rawPythonScript = this.pythonParameters.getRawScript().replaceAll("\\r\\n", System.lineSeparator());
        Map<String, Property> paramsMap = this.mergeParamsWithContext(this.pythonParameters);
        return ParameterUtils.convertParameterPlaceholders((String)rawPythonScript, (Map)ParameterUtils.convert(paramsMap));
    }

    protected Map<String, Property> mergeParamsWithContext(AbstractParameters parameters) {
        return this.taskRequest.getPrepareParamsMap();
    }

    protected String buildPythonExecuteCommand(String pythonFile) {
        Preconditions.checkNotNull((Object)pythonFile, (Object)"Python file cannot be null");
        String pythonHome = String.format("${%s}", PYTHON_LAUNCHER);
        return pythonHome + " " + pythonFile;
    }
}

