/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.java;

import com.google.common.base.Preconditions;
import java.io.File;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.resource.ResourceContext;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.shell.ShellInterceptorBuilderFactory;
import org.apache.dolphinscheduler.plugin.task.java.JavaConstants;
import org.apache.dolphinscheduler.plugin.task.java.JavaParameters;
import org.apache.dolphinscheduler.plugin.task.java.MainClassExtractor;
import org.apache.dolphinscheduler.plugin.task.java.exception.RunTypeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaTask.class);
    private JavaParameters javaParameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskExecutionContext taskRequest;

    public JavaTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.taskRequest = taskRequest;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((JavaTask)this).logHandle(arg_0), taskRequest);
    }

    public void init() {
        this.javaParameters = (JavaParameters)((Object)JSONUtils.parseObject((String)this.taskRequest.getTaskParams(), JavaParameters.class));
        if (this.javaParameters == null || !this.javaParameters.checkParameters()) {
            throw new TaskException("java task params is not valid");
        }
        log.info("Initialize java task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.javaParameters)));
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String command = null;
            switch (this.javaParameters.getRunType()) {
                case "FAT_JAR": {
                    command = this.buildJarCommand();
                    break;
                }
                case "NORMAL_JAR": {
                    command = this.buildNormalJarCommand();
                    break;
                }
                default: {
                    throw new RunTypeNotFoundException("run type is required, but it is null now.");
                }
            }
            Preconditions.checkNotNull((Object)command, (Object)"command not be null.");
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().appendScript(command);
            TaskResponse taskResponse = this.shellCommandExecutor.run(shellActuatorBuilder, taskCallBack);
            log.info("java task run result: {}", (Object)taskResponse);
            this.setExitStatusCode(taskResponse.getExitStatusCode());
            this.setAppIds(taskResponse.getAppIds());
            this.setProcessId(taskResponse.getProcessId());
            this.setTaskOutputParams(this.shellCommandExecutor.getTaskOutputParams());
        }
        catch (InterruptedException e) {
            log.error("java task interrupted ", (Throwable)e);
            this.setExitStatusCode(-1);
            Thread.currentThread().interrupt();
        }
        catch (RunTypeNotFoundException e) {
            log.error(e.getMessage());
            this.setExitStatusCode(-1);
            throw e;
        }
        catch (Exception e) {
            log.error("java task failed ", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("run java task error", (Throwable)e);
        }
    }

    protected String buildJarCommand() {
        ResourceContext resourceContext = this.taskRequest.getResourceContext();
        String mainJarAbsolutePathInLocal = resourceContext.getResourceItem(this.javaParameters.getMainJar().getResourceName()).getResourceAbsolutePathInLocal();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getJavaCommandPath()).append("java").append(" ").append(this.buildResourcePath()).append(" ").append("-jar").append(" ").append(mainJarAbsolutePathInLocal).append(" ").append(this.javaParameters.getMainArgs().trim()).append(" ").append(this.javaParameters.getJvmArgs().trim());
        return builder.toString();
    }

    protected String buildNormalJarCommand() {
        ResourceContext resourceContext = this.taskRequest.getResourceContext();
        String mainJarAbsolutePathInLocal = resourceContext.getResourceItem(this.javaParameters.getMainJar().getResourceName()).getResourceAbsolutePathInLocal();
        String mainClassName = this.javaParameters.getMainClass();
        String mainJarName = mainClassName == null || StringUtils.isEmpty((CharSequence)mainClassName) ? MainClassExtractor.getMainClassName(mainJarAbsolutePathInLocal) : mainClassName;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getJavaCommandPath()).append("java").append(" ").append(this.buildResourcePath()).append(" ").append(mainJarName).append(" ").append(this.javaParameters.getMainArgs().trim()).append(" ").append(this.javaParameters.getJvmArgs().trim());
        return builder.toString();
    }

    public void cancel() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException();
        }
    }

    public AbstractParameters getParameters() {
        return this.javaParameters;
    }

    protected String buildResourcePath() {
        StringBuilder builder = new StringBuilder();
        if (this.javaParameters.isModulePath()) {
            builder.append("--module-path");
        } else {
            builder.append("-classpath");
        }
        builder.append(" ").append(".").append(JavaConstants.PATH_SEPARATOR).append(this.taskRequest.getExecutePath());
        ResourceContext resourceContext = this.taskRequest.getResourceContext();
        for (ResourceInfo info : this.javaParameters.getResourceFilesList()) {
            builder.append(JavaConstants.PATH_SEPARATOR);
            builder.append(resourceContext.getResourceItem(info.getResourceName()).getResourceAbsolutePathInLocal());
        }
        return builder.toString();
    }

    private String getJavaCommandPath() {
        return "${JAVA_HOME}" + File.separator + "bin" + File.separator;
    }
}

