/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.flink;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.flink.FileUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkArgsUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkTask
extends AbstractYarnTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlinkTask.class);
    private FlinkParameters flinkParameters;
    private TaskExecutionContext taskExecutionContext;
    protected static final Pattern FLINK_APPLICATION_REGEX = Pattern.compile("JobID \\w+");

    public FlinkTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.flinkParameters = (FlinkParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), FlinkParameters.class));
        log.info("Initialize flink task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.flinkParameters)));
        if (this.flinkParameters == null || !this.flinkParameters.checkParameters()) {
            throw new RuntimeException("flink task params is not valid");
        }
        FileUtils.generateScriptFile(this.taskExecutionContext, this.flinkParameters);
    }

    protected String getScript() {
        List<String> args = FlinkArgsUtils.buildRunCommandLine(this.taskExecutionContext, this.flinkParameters);
        return args.stream().collect(Collectors.joining(" "));
    }

    public AbstractParameters getParameters() {
        return this.flinkParameters;
    }

    protected String findAppId(String line) {
        Matcher matcher = FLINK_APPLICATION_REGEX.matcher(line);
        if (matcher.find()) {
            String str = matcher.group();
            return str.substring(6);
        }
        return null;
    }
}

