/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.DBTaskAckCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.cache.ResponceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTaskAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(DBTaskAckProcessor.class);

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.DB_TASK_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        DBTaskAckCommand taskAckCommand = (DBTaskAckCommand)JSONUtils.parseObject((byte[])command.getBody(), DBTaskAckCommand.class);
        if (taskAckCommand == null) {
            return;
        }
        if (taskAckCommand.getStatus() == ExecutionStatus.SUCCESS.getCode()) {
            ResponceCache.get().removeAckCache(taskAckCommand.getTaskInstanceId());
            this.logger.debug("removeAckCache: taskinstance id:{}", (Object)taskAckCommand.getTaskInstanceId());
        }
    }
}

