/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import java.util.Collection;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.AbstractSelector;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWeight;

public class LowerWeightRoundRobin
extends AbstractSelector<HostWeight> {
    @Override
    public HostWeight doSelect(Collection<HostWeight> sources) {
        double totalWeight = 0.0;
        double lowWeight = 0.0;
        HostWeight lowerNode = null;
        for (HostWeight hostWeight : sources) {
            totalWeight += hostWeight.getWeight();
            hostWeight.setCurrentWeight(hostWeight.getCurrentWeight() + hostWeight.getWeight());
            if (lowerNode != null && !(lowWeight > hostWeight.getCurrentWeight())) continue;
            lowerNode = hostWeight;
            lowWeight = hostWeight.getCurrentWeight();
        }
        lowerNode.setCurrentWeight(lowerNode.getCurrentWeight() + totalWeight);
        return lowerNode;
    }
}

