/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLogFilter
extends Filter<ILoggingEvent> {
    private static Logger logger = LoggerFactory.getLogger(TaskLogFilter.class);
    private Level level;

    public void setLevel(String level) {
        this.level = Level.toLevel((String)level);
    }

    public FilterReply decide(ILoggingEvent event) {
        FilterReply filterReply = FilterReply.DENY;
        if (event.getThreadName().startsWith("TaskLogInfo") && event.getLoggerName().startsWith("TaskLogLogger") || event.getLevel().isGreaterOrEqual(this.level)) {
            filterReply = FilterReply.ACCEPT;
        }
        logger.debug("task log filter, thread name:{},loggerName:{},filterReply:{}", new Object[]{event.getThreadName(), event.getLoggerName(), filterReply.name()});
        return filterReply;
    }
}

