/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.serializer;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProtoStuffUtils {
    private static LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
    private static Map<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    private ProtoStuffUtils() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] serialize(T obj) {
        byte[] data;
        Class<?> clazz = obj.getClass();
        Schema<?> schema = ProtoStuffUtils.getSchema(clazz);
        try {
            data = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        return data;
    }

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        return schemaCache.computeIfAbsent(clazz, RuntimeSchema::createFrom);
    }

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        Schema<T> schema = ProtoStuffUtils.getSchema(clazz);
        Object obj = schema.newMessage();
        if (null == obj) {
            return null;
        }
        ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)obj, schema);
        return (T)obj;
    }
}

