/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import org.apache.dolphinscheduler.remote.command.Message;
import org.apache.dolphinscheduler.remote.utils.ChannelUtils;
import org.apache.dolphinscheduler.remote.utils.Host;

public class NettyRemoteChannel {
    private final Channel channel;
    private final long opaque;
    private final Host host;

    public NettyRemoteChannel(Channel channel, long opaque) {
        this.channel = channel;
        this.host = ChannelUtils.toAddress(channel);
        this.opaque = opaque;
    }

    public NettyRemoteChannel(Channel channel) {
        this.channel = channel;
        this.host = ChannelUtils.toAddress(channel);
        this.opaque = -1L;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public Host getHost() {
        return this.host;
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public ChannelFuture writeAndFlush(Message message) {
        return this.channel.writeAndFlush((Object)message);
    }

    public void close() {
        this.channel.close();
    }
}

