/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.command.workflow;

import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.RequestMessageBuilder;

public class WorkflowStateEventChangeRequest
implements RequestMessageBuilder {
    private String key;
    private WorkflowExecutionStatus sourceStatus;
    private int sourceProcessInstanceId;
    private int sourceTaskInstanceId;
    private int destProcessInstanceId;
    private int destTaskInstanceId;

    public WorkflowStateEventChangeRequest(int sourceProcessInstanceId, int sourceTaskInstanceId, WorkflowExecutionStatus sourceStatus, int destProcessInstanceId, int destTaskInstanceId) {
        this.key = String.format("%d-%d-%d-%d", sourceProcessInstanceId, sourceTaskInstanceId, destProcessInstanceId, destTaskInstanceId);
        this.sourceStatus = sourceStatus;
        this.sourceProcessInstanceId = sourceProcessInstanceId;
        this.sourceTaskInstanceId = sourceTaskInstanceId;
        this.destProcessInstanceId = destProcessInstanceId;
        this.destTaskInstanceId = destTaskInstanceId;
    }

    @Override
    public MessageType getCommandType() {
        return MessageType.STATE_EVENT_REQUEST;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public WorkflowExecutionStatus getSourceStatus() {
        return this.sourceStatus;
    }

    @Generated
    public int getSourceProcessInstanceId() {
        return this.sourceProcessInstanceId;
    }

    @Generated
    public int getSourceTaskInstanceId() {
        return this.sourceTaskInstanceId;
    }

    @Generated
    public int getDestProcessInstanceId() {
        return this.destProcessInstanceId;
    }

    @Generated
    public int getDestTaskInstanceId() {
        return this.destTaskInstanceId;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setSourceStatus(WorkflowExecutionStatus sourceStatus) {
        this.sourceStatus = sourceStatus;
    }

    @Generated
    public void setSourceProcessInstanceId(int sourceProcessInstanceId) {
        this.sourceProcessInstanceId = sourceProcessInstanceId;
    }

    @Generated
    public void setSourceTaskInstanceId(int sourceTaskInstanceId) {
        this.sourceTaskInstanceId = sourceTaskInstanceId;
    }

    @Generated
    public void setDestProcessInstanceId(int destProcessInstanceId) {
        this.destProcessInstanceId = destProcessInstanceId;
    }

    @Generated
    public void setDestTaskInstanceId(int destTaskInstanceId) {
        this.destTaskInstanceId = destTaskInstanceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowStateEventChangeRequest)) {
            return false;
        }
        WorkflowStateEventChangeRequest other = (WorkflowStateEventChangeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSourceProcessInstanceId() != other.getSourceProcessInstanceId()) {
            return false;
        }
        if (this.getSourceTaskInstanceId() != other.getSourceTaskInstanceId()) {
            return false;
        }
        if (this.getDestProcessInstanceId() != other.getDestProcessInstanceId()) {
            return false;
        }
        if (this.getDestTaskInstanceId() != other.getDestTaskInstanceId()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        WorkflowExecutionStatus this$sourceStatus = this.getSourceStatus();
        WorkflowExecutionStatus other$sourceStatus = other.getSourceStatus();
        return !(this$sourceStatus == null ? other$sourceStatus != null : !this$sourceStatus.equals(other$sourceStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowStateEventChangeRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSourceProcessInstanceId();
        result = result * 59 + this.getSourceTaskInstanceId();
        result = result * 59 + this.getDestProcessInstanceId();
        result = result * 59 + this.getDestTaskInstanceId();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        WorkflowExecutionStatus $sourceStatus = this.getSourceStatus();
        result = result * 59 + ($sourceStatus == null ? 43 : $sourceStatus.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkflowStateEventChangeRequest(key=" + this.getKey() + ", sourceStatus=" + this.getSourceStatus() + ", sourceProcessInstanceId=" + this.getSourceProcessInstanceId() + ", sourceTaskInstanceId=" + this.getSourceTaskInstanceId() + ", destProcessInstanceId=" + this.getDestProcessInstanceId() + ", destTaskInstanceId=" + this.getDestTaskInstanceId() + ")";
    }

    @Generated
    public WorkflowStateEventChangeRequest() {
    }
}

