/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.command.task;

import lombok.Generated;
import org.apache.dolphinscheduler.remote.command.MessageType;
import org.apache.dolphinscheduler.remote.command.RequestMessageBuilder;

public class TaskWakeupRequest
implements RequestMessageBuilder {
    private String key;
    private int processInstanceId;
    private int taskInstanceId;

    public TaskWakeupRequest(int processInstanceId, int taskInstanceId) {
        this.key = String.format("%d-%d", processInstanceId, taskInstanceId);
        this.processInstanceId = processInstanceId;
        this.taskInstanceId = taskInstanceId;
    }

    @Override
    public MessageType getCommandType() {
        return MessageType.TASK_WAKEUP_EVENT_REQUEST;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Generated
    public int getTaskInstanceId() {
        return this.taskInstanceId;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Generated
    public void setTaskInstanceId(int taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskWakeupRequest)) {
            return false;
        }
        TaskWakeupRequest other = (TaskWakeupRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessInstanceId() != other.getProcessInstanceId()) {
            return false;
        }
        if (this.getTaskInstanceId() != other.getTaskInstanceId()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskWakeupRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProcessInstanceId();
        result = result * 59 + this.getTaskInstanceId();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskWakeupRequest(key=" + this.getKey() + ", processInstanceId=" + this.getProcessInstanceId() + ", taskInstanceId=" + this.getTaskInstanceId() + ")";
    }

    @Generated
    public TaskWakeupRequest() {
    }

    @Generated
    public TaskWakeupRequest(String key, int processInstanceId, int taskInstanceId) {
        this.key = key;
        this.processInstanceId = processInstanceId;
        this.taskInstanceId = taskInstanceId;
    }
}

