/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.future;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.future.InvokeCallback;
import org.apache.dolphinscheduler.remote.future.ReleaseSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFuture {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseFuture.class);
    private static final ConcurrentHashMap<Long, ResponseFuture> FUTURE_TABLE = new ConcurrentHashMap(256);
    private final long opaque;
    private final long timeoutMillis;
    private final InvokeCallback invokeCallback;
    private final ReleaseSemaphore releaseSemaphore;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final long beginTimestamp = System.currentTimeMillis();
    private Command responseCommand;
    private volatile boolean sendOk = true;
    private Throwable cause;

    public ResponseFuture(long opaque, long timeoutMillis, InvokeCallback invokeCallback, ReleaseSemaphore releaseSemaphore) {
        this.opaque = opaque;
        this.timeoutMillis = timeoutMillis;
        this.invokeCallback = invokeCallback;
        this.releaseSemaphore = releaseSemaphore;
        FUTURE_TABLE.put(opaque, this);
    }

    public Command waitResponse() throws InterruptedException {
        this.latch.await(this.timeoutMillis, TimeUnit.MILLISECONDS);
        return this.responseCommand;
    }

    public void putResponse(Command responseCommand) {
        this.responseCommand = responseCommand;
        this.latch.countDown();
        FUTURE_TABLE.remove(this.opaque);
    }

    public static ResponseFuture getFuture(long opaque) {
        return FUTURE_TABLE.get(opaque);
    }

    public boolean isTimeout() {
        long diff = System.currentTimeMillis() - this.beginTimestamp;
        return diff > this.timeoutMillis;
    }

    public void executeInvokeCallback() {
        if (this.invokeCallback != null) {
            this.invokeCallback.operationComplete(this);
        }
    }

    public boolean isSendOK() {
        return this.sendOk;
    }

    public void setSendOk(boolean sendOk) {
        this.sendOk = sendOk;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public long getBeginTimestamp() {
        return this.beginTimestamp;
    }

    public Command getResponseCommand() {
        return this.responseCommand;
    }

    public void setResponseCommand(Command responseCommand) {
        this.responseCommand = responseCommand;
    }

    public InvokeCallback getInvokeCallback() {
        return this.invokeCallback;
    }

    public void release() {
        if (this.releaseSemaphore != null) {
            this.releaseSemaphore.release();
        }
    }

    public static void scanFutureTable() {
        LinkedList<ResponseFuture> futureList = new LinkedList<ResponseFuture>();
        Iterator<Map.Entry<Long, ResponseFuture>> it = FUTURE_TABLE.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, ResponseFuture> next = it.next();
            ResponseFuture future = next.getValue();
            if (future.getBeginTimestamp() + future.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            futureList.add(future);
            it.remove();
            LOGGER.warn("remove timeout request : {}", (Object)future);
        }
        for (ResponseFuture future : futureList) {
            try {
                future.release();
                future.executeInvokeCallback();
            }
            catch (Exception ex) {
                LOGGER.warn("scanFutureTable, execute callback error", (Throwable)ex);
            }
        }
    }

    public String toString() {
        return "ResponseFuture{opaque=" + this.opaque + ", timeoutMillis=" + this.timeoutMillis + ", invokeCallback=" + this.invokeCallback + ", releaseSemaphore=" + this.releaseSemaphore + ", latch=" + this.latch + ", beginTimestamp=" + this.beginTimestamp + ", responseCommand=" + this.responseCommand + ", sendOk=" + this.sendOk + ", cause=" + this.cause + '}';
    }
}

