/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.runnable;

import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.server.master.engine.command.ICommandHandler;
import org.apache.dolphinscheduler.server.master.engine.exceptions.CommandDuplicateHandleException;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WorkflowExecutionRunnableFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecutionRunnableFactory.class);
    @Autowired
    private List<ICommandHandler> commandHandlers;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private CommandDao commandDao;

    @Transactional
    public IWorkflowExecutionRunnable createWorkflowExecuteRunnable(Command command) {
        this.deleteCommandOrThrow(command);
        return this.doCreateWorkflowExecutionRunnable(command);
    }

    private IWorkflowExecutionRunnable doCreateWorkflowExecutionRunnable(Command command) {
        CommandType commandType = command.getCommandType();
        ICommandHandler commandHandler = this.commandHandlers.stream().filter(c -> c.commandType() == commandType).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find ICommandHandler for commandType: " + commandType));
        return commandHandler.handleCommand(command);
    }

    private void deleteCommandOrThrow(Command command) {
        boolean deleteResult = this.commandDao.deleteById((Serializable)command.getId());
        if (!deleteResult) {
            throw new CommandDuplicateHandleException(command);
        }
    }
}

