/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.queue;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class DelayEntry<V extends Comparable<V>>
implements Delayed {
    private final long delayTimeMills;
    private final long triggerTimeMills;
    private final V data;

    public DelayEntry(long delayTimeMills, V data) {
        this.delayTimeMills = delayTimeMills;
        this.triggerTimeMills = System.currentTimeMillis() + delayTimeMills;
        this.data = (Comparable)Preconditions.checkNotNull(data, (Object)"data is null");
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        long remainTimeMills = this.triggerTimeMills - System.currentTimeMillis();
        if (TimeUnit.MILLISECONDS.equals((Object)unit)) {
            return remainTimeMills;
        }
        return unit.convert(remainTimeMills, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@NotNull Delayed o) {
        DelayEntry other = (DelayEntry)o;
        int delayTimeMillsCompareResult = Long.compare(this.delayTimeMills, other.delayTimeMills);
        if (delayTimeMillsCompareResult != 0) {
            return delayTimeMillsCompareResult;
        }
        if (this.data == null || other.data == null) {
            return 0;
        }
        return this.data.compareTo(other.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelayEntry that = (DelayEntry)o;
        return this.delayTimeMills == that.delayTimeMills && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.delayTimeMills, this.data);
    }

    @Generated
    public V getData() {
        return this.data;
    }
}

