/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.IEnvironmentDao;
import org.apache.dolphinscheduler.dao.utils.EnvironmentUtils;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.K8sTaskParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.AbstractResourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.DataSourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionContextBuilder;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionContextCreateRequest;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecutionContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionContextFactory.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private CuringParamsService curingParamsService;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private IEnvironmentDao environmentDao;

    public TaskExecutionContext createTaskExecutionContext(TaskExecutionContextCreateRequest request) {
        TaskInstance taskInstance = request.getTaskInstance();
        WorkflowInstance workflowInstance = request.getWorkflowInstance();
        WorkflowDefinition workflowDefinition = request.getWorkflowDefinition();
        Project project = request.getProject();
        return TaskExecutionContextBuilder.get().buildWorkflowInstanceHost(this.masterConfig.getMasterAddress()).buildTaskInstanceRelatedInfo(taskInstance).buildEnvironmentConfig(this.getEnvironmentConfigFromDB(taskInstance).orElse(null)).buildTaskDefinitionRelatedInfo(request.getTaskDefinition()).buildProcessInstanceRelatedInfo(request.getWorkflowInstance()).buildResourceParameters(this.getResourceParameters(taskInstance)).buildBusinessParams(this.getBusinessParams(workflowInstance)).buildPrepareParams(this.getPrepareParams(taskInstance, workflowInstance, workflowDefinition, project)).buildK8sTaskRelatedInfo(this.getK8sTaskExecutionContext(taskInstance)).create();
    }

    private ResourceParametersHelper getResourceParameters(TaskInstance taskInstance) {
        ResourceParametersHelper resourceParameters = TaskPluginManager.getTaskChannel((String)taskInstance.getTaskType()).parseParameters(taskInstance.getTaskParams()).getResources();
        if (resourceParameters != null) {
            resourceParameters.getResourceMap().forEach((type, map) -> {
                switch (type) {
                    case DATASOURCE: {
                        this.assembleDataSourceParameters((Map<Integer, AbstractResourceParameters>)map);
                        break;
                    }
                }
            });
        }
        return resourceParameters;
    }

    private void assembleDataSourceParameters(Map<Integer, AbstractResourceParameters> map) {
        if (MapUtils.isEmpty(map)) {
            return;
        }
        map.forEach((code, parameters) -> {
            DataSource datasource = this.processService.findDataSourceById(code.intValue());
            if (Objects.isNull(datasource)) {
                return;
            }
            DataSourceParameters dataSourceParameters = new DataSourceParameters();
            dataSourceParameters.setType(datasource.getType());
            dataSourceParameters.setConnectionParams(datasource.getConnectionParams());
            map.put((Integer)code, (AbstractResourceParameters)dataSourceParameters);
        });
    }

    private K8sTaskExecutionContext getK8sTaskExecutionContext(TaskInstance taskInstance) {
        String clusterName;
        String configYaml;
        K8sTaskExecutionContext k8sTaskExecutionContext = null;
        String namespace = "";
        switch (taskInstance.getTaskType()) {
            case "K8S": 
            case "KUBEFLOW": {
                K8sTaskParameters k8sTaskParameters = (K8sTaskParameters)JSONUtils.parseObject((String)taskInstance.getTaskParams(), K8sTaskParameters.class);
                namespace = k8sTaskParameters.getNamespace();
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)namespace) && (configYaml = this.processService.findConfigYamlByName(clusterName = (String)JSONUtils.toMap((String)namespace).get("cluster"))) != null) {
            k8sTaskExecutionContext = new K8sTaskExecutionContext(configYaml, (String)JSONUtils.toMap((String)namespace).get("name"));
        }
        return k8sTaskExecutionContext;
    }

    private Map<String, Property> getBusinessParams(WorkflowInstance workflowInstance) {
        return this.curingParamsService.preBuildBusinessParams(workflowInstance);
    }

    private Map<String, Property> getPrepareParams(TaskInstance taskInstance, WorkflowInstance workflowInstance, WorkflowDefinition workflowDefinition, Project project) {
        AbstractParameters baseParam = TaskPluginManager.parseTaskParameters((String)taskInstance.getTaskType(), (String)taskInstance.getTaskParams());
        return this.curingParamsService.paramParsingPreparation(taskInstance, baseParam, workflowInstance, project.getName(), workflowDefinition.getName());
    }

    private Optional<String> getEnvironmentConfigFromDB(TaskInstance taskInstance) {
        if (EnvironmentUtils.isEnvironmentCodeEmpty((Long)taskInstance.getEnvironmentCode())) {
            return Optional.empty();
        }
        Optional environmentOptional = this.environmentDao.queryByEnvironmentCode(taskInstance.getEnvironmentCode());
        if (!environmentOptional.isPresent()) {
            throw new IllegalArgumentException("Cannot find the environment: " + taskInstance.getEnvironmentCode());
        }
        return Optional.ofNullable(((Environment)environmentOptional.get()).getConfig());
    }
}

