/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.statemachine;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.VarPoolUtils;
import org.apache.dolphinscheduler.server.master.engine.AbstractLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.ITaskGroupCoordinator;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowRepository;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.task.client.ITaskExecutorClient;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKilledLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskPausedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRetryLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRunningLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskRuntimeContextChangedEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskSuccessLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.ITaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTaskStateAction
implements ITaskStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTaskStateAction.class);
    @Autowired
    protected ITaskGroupCoordinator taskGroupCoordinator;
    @Autowired
    protected TaskInstanceDao taskInstanceDao;
    @Autowired
    protected IWorkflowRepository workflowRepository;
    @Autowired
    protected ITaskExecutorClient taskExecutorClient;

    protected boolean isTaskNeedAcquireTaskGroupSlot(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        return this.taskGroupCoordinator.needAcquireTaskGroupSlot(taskInstance);
    }

    protected void acquireTaskGroupSlot(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        this.taskGroupCoordinator.acquireTaskGroupSlot(taskInstance);
    }

    protected void releaseTaskInstanceResourcesIfNeeded(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        if (this.taskGroupCoordinator.needToReleaseTaskGroupSlot(taskInstance)) {
            this.taskGroupCoordinator.releaseTaskGroupSlot(taskInstance);
        }
    }

    @Override
    public void dispatchedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskDispatchedLifecycleEvent taskDispatchedEvent) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        taskInstance.setState(TaskExecutionStatus.DISPATCH);
        taskInstance.setHost(taskDispatchedEvent.getExecutorHost());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    @Override
    public void runtimeContextChangedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskRuntimeContextChangedEvent taskRuntimeContextChangedEvent) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        if (StringUtils.isNotEmpty((CharSequence)taskRuntimeContextChangedEvent.getRuntimeContext())) {
            taskInstance.setAppLink(taskRuntimeContextChangedEvent.getRuntimeContext());
        }
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    protected void persistentTaskInstanceStartedEventToDB(ITaskExecutionRunnable taskExecutionRunnable, TaskRunningLifecycleEvent taskRunningEvent) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        taskInstance.setState(TaskExecutionStatus.RUNNING_EXECUTION);
        taskInstance.setStartTime(taskRunningEvent.getStartTime());
        taskInstance.setLogPath(taskRunningEvent.getLogPath());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    @Override
    public void pausedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskPausedLifecycleEvent taskPausedEvent) {
        this.releaseTaskInstanceResourcesIfNeeded(taskExecutionRunnable);
        this.persistentTaskInstancePausedEventToDB(taskExecutionRunnable, taskPausedEvent);
        taskExecutionRunnable.getWorkflowExecutionGraph().markTaskExecutionRunnableChainPause(taskExecutionRunnable);
        this.publishWorkflowInstanceTopologyLogicalTransitionEvent(taskExecutionRunnable);
    }

    private void persistentTaskInstancePausedEventToDB(ITaskExecutionRunnable taskExecutionRunnable, TaskPausedLifecycleEvent taskPausedEvent) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        taskInstance.setState(TaskExecutionStatus.PAUSE);
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    @Override
    public void killedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskKilledLifecycleEvent taskInstanceKillEvent) {
        this.releaseTaskInstanceResourcesIfNeeded(taskExecutionRunnable);
        this.persistentTaskInstanceKilledEventToDB(taskExecutionRunnable, taskInstanceKillEvent);
        taskExecutionRunnable.getWorkflowExecutionGraph().markTaskExecutionRunnableChainKill(taskExecutionRunnable);
        this.publishWorkflowInstanceTopologyLogicalTransitionEvent(taskExecutionRunnable);
    }

    private void persistentTaskInstanceKilledEventToDB(ITaskExecutionRunnable taskExecutionRunnable, TaskKilledLifecycleEvent taskKilledEvent) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        taskInstance.setState(TaskExecutionStatus.KILL);
        taskInstance.setEndTime(taskKilledEvent.getEndTime());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    @Override
    public void failedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskFailedLifecycleEvent taskFailedEvent) {
        this.releaseTaskInstanceResourcesIfNeeded(taskExecutionRunnable);
        this.persistentTaskInstanceFailedEventToDB(taskExecutionRunnable, taskFailedEvent);
        if (taskExecutionRunnable.isTaskInstanceCanRetry()) {
            taskExecutionRunnable.getWorkflowEventBus().publish(TaskRetryLifecycleEvent.of(taskExecutionRunnable));
            return;
        }
        IWorkflowExecutionGraph workflowExecutionGraph = taskExecutionRunnable.getWorkflowExecutionGraph();
        if (workflowExecutionGraph.isAllSuccessorsAreConditionTask(taskExecutionRunnable)) {
            this.publishWorkflowInstanceTopologyLogicalTransitionEvent(taskExecutionRunnable);
            return;
        }
        taskExecutionRunnable.getWorkflowExecutionGraph().markTaskExecutionRunnableChainFailure(taskExecutionRunnable);
        this.publishWorkflowInstanceTopologyLogicalTransitionEvent(taskExecutionRunnable);
    }

    private void persistentTaskInstanceFailedEventToDB(ITaskExecutionRunnable taskExecutionRunnable, TaskFailedLifecycleEvent taskFailedEvent) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        taskInstance.setState(TaskExecutionStatus.FAILURE);
        taskInstance.setEndTime(taskFailedEvent.getEndTime());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    @Override
    public void succeedEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskSuccessLifecycleEvent taskSuccessEvent) {
        this.releaseTaskInstanceResourcesIfNeeded(taskExecutionRunnable);
        this.persistentTaskInstanceSuccessEventToDB(taskExecutionRunnable, taskSuccessEvent);
        this.mergeTaskVarPoolToWorkflow(workflowExecutionRunnable, taskExecutionRunnable);
        this.publishWorkflowInstanceTopologyLogicalTransitionEvent(taskExecutionRunnable);
    }

    protected void mergeTaskVarPoolToWorkflow(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        WorkflowInstance workflowInstance = workflowExecutionRunnable.getWorkflowInstance();
        String finalVarPool = VarPoolUtils.mergeVarPoolJsonString((List)Lists.newArrayList((Object[])new String[]{workflowInstance.getVarPool(), taskInstance.getVarPool()}));
        workflowInstance.setVarPool(finalVarPool);
    }

    protected void persistentTaskInstanceSuccessEventToDB(ITaskExecutionRunnable taskExecutionRunnable, TaskSuccessLifecycleEvent taskSuccessEvent) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        taskInstance.setState(TaskExecutionStatus.SUCCESS);
        taskInstance.setEndTime(taskSuccessEvent.getEndTime());
        taskInstance.setVarPool(taskSuccessEvent.getVarPool());
        this.taskInstanceDao.updateById((Object)taskInstance);
    }

    protected void failoverTask(ITaskExecutionRunnable taskExecutionRunnable) {
        taskExecutionRunnable.failover();
    }

    protected void tryToDispatchTask(ITaskExecutionRunnable taskExecutionRunnable) {
        if (this.isTaskNeedAcquireTaskGroupSlot(taskExecutionRunnable)) {
            this.acquireTaskGroupSlot(taskExecutionRunnable);
            log.info("Task{} using taskGroup, success acquire taskGroup slot", (Object)taskExecutionRunnable.getName());
            return;
        }
        taskExecutionRunnable.getWorkflowEventBus().publish(TaskDispatchLifecycleEvent.of(taskExecutionRunnable));
    }

    protected void publishWorkflowInstanceTopologyLogicalTransitionEvent(ITaskExecutionRunnable taskExecutionRunnable) {
        Integer workflowInstanceId = taskExecutionRunnable.getWorkflowInstance().getId();
        IWorkflowExecutionRunnable workflowExecutionRunnable = this.workflowRepository.get(workflowInstanceId);
        taskExecutionRunnable.getWorkflowExecutionGraph().markTaskExecutionRunnableInActive(taskExecutionRunnable);
        taskExecutionRunnable.getWorkflowEventBus().publish(WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent.of(workflowExecutionRunnable, taskExecutionRunnable));
    }

    protected void throwExceptionIfStateIsNotMatch(ITaskExecutionRunnable taskExecutionRunnable) {
        Preconditions.checkNotNull((Object)taskExecutionRunnable, (Object)"taskExecutionRunnable is null");
        TaskInstance taskInstance = (TaskInstance)Preconditions.checkNotNull((Object)taskExecutionRunnable.getTaskInstance(), (Object)"taskInstance is null");
        TaskExecutionStatus actualState = taskInstance.getState();
        TaskExecutionStatus expectState = this.matchState();
        if (actualState != expectState) {
            String taskName = taskInstance.getName();
            throw new IllegalStateException("The task: " + taskName + " state: " + actualState + " is not match:" + expectState);
        }
    }

    protected void logWarningIfCannotDoAction(ITaskExecutionRunnable taskExecutionRunnable, AbstractLifecycleEvent event) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        log.warn("Task {} state is {} cannot do action on event: {}", new Object[]{taskInstance.getName(), taskInstance.getState(), event});
    }
}

