/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler;

import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.client.TaskExecutorClient;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.TaskLifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskSuccessLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler.AbstractTaskLifecycleEventHandler;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.ITaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorLifecycleEventType;
import org.springframework.stereotype.Component;

@Component
public class TaskSuccessLifecycleEventHandler
extends AbstractTaskLifecycleEventHandler<TaskSuccessLifecycleEvent> {
    private final TaskExecutorClient taskExecutorClient;

    public TaskSuccessLifecycleEventHandler(TaskExecutorClient taskExecutorClient) {
        this.taskExecutorClient = taskExecutorClient;
    }

    @Override
    public void handle(ITaskStateAction taskStateAction, IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskSuccessLifecycleEvent taskSuccessEvent) {
        taskStateAction.succeedEventAction(workflowExecutionRunnable, taskExecutionRunnable, taskSuccessEvent);
        this.taskExecutorClient.ackTaskExecutorLifecycleEvent(taskExecutionRunnable, new ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck(taskExecutionRunnable.getId(), TaskExecutorLifecycleEventType.SUCCESS));
    }

    @Override
    public ILifecycleEventType matchEventType() {
        return TaskLifecycleEventType.SUCCEEDED;
    }
}

