/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.subworkflow;

import java.io.Serializable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.subworkflow.SubWorkflowLogicTaskRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubWorkflowTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubWorkflowTracker.class);
    private final WorkflowInstanceDao workflowInstanceDao;
    private final SubWorkflowLogicTaskRuntimeContext subWorkflowLogicTaskRuntimeContext;

    public SubWorkflowTracker(SubWorkflowLogicTaskRuntimeContext subWorkflowLogicTaskRuntimeContext, WorkflowInstanceDao workflowInstanceDao) {
        this.subWorkflowLogicTaskRuntimeContext = subWorkflowLogicTaskRuntimeContext;
        this.workflowInstanceDao = workflowInstanceDao;
    }

    @NonNull
    public TaskExecutionStatus getSubWorkflowState() {
        Integer subWorkflowInstanceId = this.subWorkflowLogicTaskRuntimeContext.getSubWorkflowInstanceId();
        WorkflowInstance subWorkflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)subWorkflowInstanceId);
        if (subWorkflowInstance == null) {
            log.info("Cannot find the SubWorkflow instance: {}, maybe it has been deleted", (Object)subWorkflowInstanceId);
            return TaskExecutionStatus.FAILURE;
        }
        switch (subWorkflowInstance.getState()) {
            case PAUSE: {
                return TaskExecutionStatus.PAUSE;
            }
            case STOP: {
                return TaskExecutionStatus.KILL;
            }
            case SUCCESS: {
                return TaskExecutionStatus.SUCCESS;
            }
            case FAILURE: {
                return TaskExecutionStatus.FAILURE;
            }
        }
        return TaskExecutionStatus.RUNNING_EXECUTION;
    }
}

