/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.fake;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.parameters.LogicFakeTaskParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.AbstractLogicTask;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ITaskParameterDeserializer;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class LogicFakeTask
extends AbstractLogicTask<LogicFakeTaskParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicFakeTask.class);
    private Process process;

    public LogicFakeTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.onTaskRunning();
    }

    @Override
    public void start() throws MasterTaskExecuteException {
        try {
            log.info("Begin to execute LogicFakeTask: {}", (Object)this.taskExecutionContext.getTaskName());
            String shellScript = ParameterUtils.convertParameterPlaceholders((String)((LogicFakeTaskParameters)this.taskParameters).getShellScript(), (Map)ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap()));
            if (StringUtils.isNotEmpty((CharSequence)this.taskExecutionContext.getEnvironmentConfig())) {
                shellScript = this.taskExecutionContext.getEnvironmentConfig() + "\n" + shellScript;
            }
            String[] cmd = new String[]{"/bin/sh", "-c", shellScript};
            this.process = Runtime.getRuntime().exec(cmd);
            int exitCode = this.process.waitFor();
            if (this.taskExecutionStatus != TaskExecutionStatus.RUNNING_EXECUTION) {
                return;
            }
            if (exitCode == 0) {
                log.info("LogicFakeTask: {} execute success with exit code: {}", (Object)this.taskExecutionContext.getTaskName(), (Object)exitCode);
                this.onTaskSuccess();
            } else {
                log.info("LogicFakeTask: {} execute failed with exit code: {}", (Object)this.taskExecutionContext.getTaskName(), (Object)exitCode);
                this.onTaskFailed();
            }
        }
        catch (Exception ex) {
            throw new MasterTaskExecuteException("FakeTask execute failed", ex);
        }
    }

    @Override
    public void pause() throws MasterTaskExecuteException {
        log.info("LogicFakeTask: {} doesn't support pause", (Object)this.taskExecutionContext.getTaskName());
    }

    @Override
    public void kill() throws MasterTaskExecuteException {
        if (this.process != null && this.process.isAlive()) {
            this.onTaskKilled();
            this.process.destroyForcibly();
            log.info("Kill LogicFakeTask: {} succeed", (Object)this.taskExecutionContext.getTaskName());
        }
    }

    @Override
    public ITaskParameterDeserializer<LogicFakeTaskParameters> getTaskParameterDeserializer() {
        return taskParamsJson -> (LogicFakeTaskParameters)JSONUtils.parseObject((String)taskParamsJson, (TypeReference)new TypeReference<LogicFakeTaskParameters>(){});
    }
}

