/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.condition;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.model.ConditionDependentItem;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ConditionsParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.AbstractLogicTask;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ITaskParameterDeserializer;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionLogicTask
extends AbstractLogicTask<ConditionsParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConditionLogicTask.class);
    private final TaskInstanceDao taskInstanceDao;
    private final TaskInstance taskInstance;

    public ConditionLogicTask(IWorkflowExecutionRunnable workflowExecutionRunnable, TaskExecutionContext taskExecutionContext, TaskInstanceDao taskInstanceDao) {
        super(taskExecutionContext);
        this.taskInstance = workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph().getTaskExecutionRunnableById(taskExecutionContext.getTaskInstanceId()).getTaskInstance();
        this.taskInstanceDao = taskInstanceDao;
        this.onTaskRunning();
    }

    @Override
    public void start() {
        DependResult conditionResult = this.calculateConditionResult();
        log.info("The condition result is {}", (Object)conditionResult);
        ((ConditionsParameters)this.taskParameters).getConditionResult().setConditionSuccess(conditionResult == DependResult.SUCCESS);
        this.taskInstance.setTaskParams(JSONUtils.toJsonString((Object)this.taskParameters));
        this.onTaskSuccess();
    }

    private DependResult calculateConditionResult() {
        List taskInstances = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(Integer.valueOf(this.taskExecutionContext.getWorkflowInstanceId()), this.taskExecutionContext.getTestFlag());
        Map taskInstanceMap = taskInstances.stream().collect(Collectors.toMap(TaskInstance::getTaskCode, Function.identity()));
        ConditionsParameters.ConditionDependency dependence = ((ConditionsParameters)this.taskParameters).getDependence();
        List dependResults = dependence.getDependTaskList().stream().map(dependentTaskModel -> DependentUtils.getDependResultForRelation((DependentRelation)dependentTaskModel.getRelation(), dependentTaskModel.getDependItemList().stream().map(dependentItem -> this.getDependResultForItem((ConditionDependentItem)dependentItem, taskInstanceMap)).collect(Collectors.toList()))).collect(Collectors.toList());
        return DependentUtils.getDependResultForRelation((DependentRelation)dependence.getRelation(), dependResults);
    }

    private DependResult getDependResultForItem(ConditionDependentItem item, Map<Long, TaskInstance> taskInstanceMap) {
        TaskInstance taskInstance = taskInstanceMap.get(item.getDepTaskCode());
        if (taskInstance == null) {
            log.info("The depend item: {} has not completed yet", (Object)DependResult.FAILED);
            log.info("The dependent result will be {}", (Object)DependResult.FAILED);
            return DependResult.FAILED;
        }
        DependResult dependResult = Objects.equals(item.getStatus(), taskInstance.getState()) ? DependResult.SUCCESS : DependResult.FAILED;
        log.info("The depend item: {}", (Object)item);
        log.info("Expect status: {}", (Object)item.getStatus());
        log.info("Actual status: {}", (Object)taskInstance.getState());
        log.info("The dependent result will be: {}", (Object)dependResult);
        return dependResult;
    }

    @Override
    public void pause() throws MasterTaskExecuteException {
        log.info("The ConditionTask does not support pause operation");
    }

    @Override
    public void kill() throws MasterTaskExecuteException {
        log.info("The ConditionTask does not support kill operation");
    }

    @Override
    public ITaskParameterDeserializer<ConditionsParameters> getTaskParameterDeserializer() {
        return taskParamsJson -> (ConditionsParameters)JSONUtils.parseObject((String)taskParamsJson, (TypeReference)new TypeReference<ConditionsParameters>(){});
    }
}

