/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.vertica.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.vertica.param.VerticaConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.vertica.param.VerticaDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class VerticaDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, VerticaDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        VerticaConnectionParam connectionParams = (VerticaConnectionParam)this.createConnectionParams(connectionJson);
        VerticaDataSourceParamDTO verticaDatasourceParamDTO = new VerticaDataSourceParamDTO();
        verticaDatasourceParamDTO.setHostAndPortByAddress(connectionParams.getAddress());
        verticaDatasourceParamDTO.setUserName(connectionParams.getUser());
        verticaDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        verticaDatasourceParamDTO.setOther(connectionParams.getOther());
        return verticaDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO dataSourceParam) {
        VerticaDataSourceParamDTO verticaDatasourceParam = (VerticaDataSourceParamDTO)dataSourceParam;
        String address = String.format("%s%s:%s", "jdbc:vertica://", verticaDatasourceParam.getHost(), verticaDatasourceParam.getPort());
        String jdbcUrl = String.format("%s/%s", address, verticaDatasourceParam.getDatabase());
        VerticaConnectionParam verticaConnectionParam = new VerticaConnectionParam();
        verticaConnectionParam.setJdbcUrl(jdbcUrl);
        verticaConnectionParam.setDatabase(verticaDatasourceParam.getDatabase());
        verticaConnectionParam.setAddress(address);
        verticaConnectionParam.setUser(verticaDatasourceParam.getUserName());
        verticaConnectionParam.setPassword(PasswordUtils.encodePassword((String)verticaDatasourceParam.getPassword()));
        verticaConnectionParam.setDriverClassName(this.getDatasourceDriver());
        verticaConnectionParam.setValidationQuery(this.getValidationQuery());
        return verticaConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, VerticaConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.vertica.jdbc.Driver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        VerticaConnectionParam verticaConnectionParam = (VerticaConnectionParam)connectionParam;
        String jdbcUrl = verticaConnectionParam.getJdbcUrl();
        if (MapUtils.isNotEmpty((Map)verticaConnectionParam.getOther())) {
            jdbcUrl = String.format("%s?%s", jdbcUrl, this.transformOther(verticaConnectionParam.getOther()));
        }
        return jdbcUrl;
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        VerticaConnectionParam verticaConnectionParam = (VerticaConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        String user = verticaConnectionParam.getUser();
        String password = PasswordUtils.decodePassword((String)verticaConnectionParam.getPassword());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), user, password);
    }

    public DbType getDbType() {
        return DbType.VERTICA;
    }

    public DataSourceProcessor create() {
        return new VerticaDataSourceProcessor();
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        otherMap.forEach((key, value) -> stringBuilder.append(String.format("%s=%s&", key, value)));
        return stringBuilder.toString();
    }
}

