/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.oracle.param;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.oracle.param.OracleConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.oracle.param.OracleDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbConnectType;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class OracleDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, OracleDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        OracleConnectionParam connectionParams = (OracleConnectionParam)this.createConnectionParams(connectionJson);
        OracleDataSourceParamDTO oracleDatasourceParamDTO = new OracleDataSourceParamDTO();
        oracleDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        oracleDatasourceParamDTO.setUserName(connectionParams.getUser());
        oracleDatasourceParamDTO.setOther(connectionParams.getOther());
        oracleDatasourceParamDTO.setConnectType(connectionParams.getConnectType());
        String hostSeperator = "//";
        if (DbConnectType.ORACLE_SID.equals((Object)connectionParams.connectType)) {
            hostSeperator = "@";
        }
        String[] hostPort = connectionParams.getAddress().split(hostSeperator);
        String[] hostPortArray = hostPort[hostPort.length - 1].split(",");
        oracleDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        oracleDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return oracleDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        String jdbcUrl;
        String address;
        OracleDataSourceParamDTO oracleParam = (OracleDataSourceParamDTO)datasourceParam;
        if (DbConnectType.ORACLE_SID.equals((Object)oracleParam.getConnectType())) {
            address = String.format("%s%s:%s", "jdbc:oracle:thin:@", oracleParam.getHost(), oracleParam.getPort());
            jdbcUrl = address + ":" + oracleParam.getDatabase();
        } else {
            address = String.format("%s%s:%s", "jdbc:oracle:thin:@//", oracleParam.getHost(), oracleParam.getPort());
            jdbcUrl = address + "/" + oracleParam.getDatabase();
        }
        OracleConnectionParam oracleConnectionParam = new OracleConnectionParam();
        oracleConnectionParam.setUser(oracleParam.getUserName());
        oracleConnectionParam.setPassword(PasswordUtils.encodePassword((String)oracleParam.getPassword()));
        oracleConnectionParam.setAddress(address);
        oracleConnectionParam.setJdbcUrl(jdbcUrl);
        oracleConnectionParam.setDatabase(oracleParam.getDatabase());
        oracleConnectionParam.setConnectType(oracleParam.getConnectType());
        oracleConnectionParam.setDriverClassName(this.getDatasourceDriver());
        oracleConnectionParam.setValidationQuery(this.getValidationQuery());
        oracleConnectionParam.setOther(oracleParam.getOther());
        return oracleConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, OracleConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "oracle.jdbc.OracleDriver";
    }

    public String getValidationQuery() {
        return "select 1 from dual";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        OracleConnectionParam oracleConnectionParam = (OracleConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)oracleConnectionParam.getOther())) {
            return String.format("%s?%s", oracleConnectionParam.getJdbcUrl(), this.transformOther(oracleConnectionParam.getOther()));
        }
        return oracleConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        OracleConnectionParam oracleConnectionParam = (OracleConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), oracleConnectionParam.getUser(), PasswordUtils.decodePassword((String)oracleConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.ORACLE;
    }

    public DataSourceProcessor create() {
        return new OracleDataSourceProcessor();
    }

    public List<String> splitAndRemoveComment(String sql) {
        if (sql.toUpperCase().contains("BEGIN") && sql.toUpperCase().contains("END")) {
            return new OracleStatementParser(sql).parseStatementList().stream().map(SQLStatement::toString).collect(Collectors.toList());
        }
        return SQLParserUtils.splitAndRemoveComment((String)sql, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.oracle);
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        otherMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", otherList);
    }
}

