/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.hana.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.hana.param.HanaConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.hana.param.HanaDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class HanaDataSourceProcessor
extends AbstractDataSourceProcessor {
    private static final String APPEND_PARAMS = "reconnect=true";

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, HanaDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        HanaConnectionParam connectionParams = (HanaConnectionParam)this.createConnectionParams(connectionJson);
        HanaDataSourceParamDTO mysqlDatasourceParamDTO = new HanaDataSourceParamDTO();
        mysqlDatasourceParamDTO.setUserName(connectionParams.getUser());
        mysqlDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        String address = connectionParams.getAddress();
        String[] hostSeperator = address.split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        mysqlDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        mysqlDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return mysqlDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO dataSourceParam) {
        HanaDataSourceParamDTO hanaDatasourceParam = (HanaDataSourceParamDTO)dataSourceParam;
        String address = String.format("%s%s:%s", "jdbc:sap://", hanaDatasourceParam.getHost(), hanaDatasourceParam.getPort());
        String jdbcUrl = String.format("%s?currentschema=%s", address, hanaDatasourceParam.getDatabase());
        HanaConnectionParam hanaConnectionParam = new HanaConnectionParam();
        hanaConnectionParam.setJdbcUrl(jdbcUrl);
        hanaConnectionParam.setValidationQuery("select 1 from DUMMY");
        hanaConnectionParam.setDatabase(hanaDatasourceParam.getDatabase());
        hanaConnectionParam.setAddress(address);
        hanaConnectionParam.setUser(hanaDatasourceParam.getUserName());
        hanaConnectionParam.setPassword(PasswordUtils.encodePassword((String)hanaDatasourceParam.getPassword()));
        hanaConnectionParam.setDriverClassName(this.getDatasourceDriver());
        hanaConnectionParam.setOther(hanaDatasourceParam.getOther());
        return hanaConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, HanaConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.sap.db.jdbc.Driver";
    }

    public String getValidationQuery() {
        return "select 1 from DUMMY";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        HanaConnectionParam hanaConnectionParam = (HanaConnectionParam)connectionParam;
        String jdbcUrl = hanaConnectionParam.getJdbcUrl();
        if (MapUtils.isNotEmpty((Map)hanaConnectionParam.getOther())) {
            return String.format("%s?%s&%s", jdbcUrl, hanaConnectionParam.getOther(), APPEND_PARAMS);
        }
        return String.format("%s&%s", jdbcUrl, APPEND_PARAMS);
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        HanaConnectionParam mysqlConnectionParam = (HanaConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        String user = mysqlConnectionParam.getUser();
        String password = PasswordUtils.decodePassword((String)mysqlConnectionParam.getPassword());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), user, password);
    }

    public DbType getDbType() {
        return DbType.HANA;
    }

    public DataSourceProcessor create() {
        return new HanaDataSourceProcessor();
    }
}

