/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.databend.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.databend.param.DatabendConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.databend.param.DatabendDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class DatabendDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, DatabendDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        DatabendConnectionParam connectionParams = (DatabendConnectionParam)this.createConnectionParams(connectionJson);
        DatabendDataSourceParamDTO databendDatasourceParamDTO = new DatabendDataSourceParamDTO();
        databendDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        databendDatasourceParamDTO.setUserName(connectionParams.getUser());
        databendDatasourceParamDTO.setOther(connectionParams.getOther());
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        databendDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        databendDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return databendDatasourceParamDTO;
    }

    public ConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        DatabendDataSourceParamDTO databendParam = (DatabendDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:databend://", databendParam.getHost(), databendParam.getPort());
        String jdbcUrl = address + "/" + databendParam.getDatabase();
        DatabendConnectionParam databendConnectionParam = new DatabendConnectionParam();
        databendConnectionParam.setDatabase(databendParam.getDatabase());
        databendConnectionParam.setAddress(address);
        databendConnectionParam.setJdbcUrl(jdbcUrl);
        databendConnectionParam.setUser(databendParam.getUserName());
        databendConnectionParam.setPassword(PasswordUtils.encodePassword((String)databendParam.getPassword()));
        databendConnectionParam.setDriverClassName(this.getDatasourceDriver());
        databendConnectionParam.setValidationQuery(this.getValidationQuery());
        databendConnectionParam.setOther(databendParam.getOther());
        return databendConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, DatabendConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.databend.jdbc.DatabendDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        DatabendConnectionParam databendConnectionParam = (DatabendConnectionParam)connectionParam;
        String jdbcUrl = databendConnectionParam.getJdbcUrl();
        if (MapUtils.isNotEmpty((Map)databendConnectionParam.getOther())) {
            jdbcUrl = String.format("%s?%s", jdbcUrl, this.transformOther(databendConnectionParam.getOther()));
        }
        return jdbcUrl;
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        DatabendConnectionParam databendConnectionParam = (DatabendConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl((ConnectionParam)databendConnectionParam), databendConnectionParam.getUser(), PasswordUtils.decodePassword((String)databendConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.DATABEND;
    }

    public DataSourceProcessor create() {
        return new DatabendDataSourceProcessor();
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        otherMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", otherList);
    }
}

