/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.athena.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.athena.param.AthenaConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.athena.param.AthenaDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class AthenaDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, AthenaDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        AthenaConnectionParam connectionParams = (AthenaConnectionParam)this.createConnectionParams(connectionJson);
        AthenaDataSourceParamDTO athenaDatasourceParamDTO = new AthenaDataSourceParamDTO();
        athenaDatasourceParamDTO.setAwsRegion(connectionParams.getAwsRegion());
        athenaDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        athenaDatasourceParamDTO.setUserName(connectionParams.getUser());
        athenaDatasourceParamDTO.setOther(connectionParams.getOther());
        return athenaDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        AthenaDataSourceParamDTO athenaParam = (AthenaDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s=%s;", "jdbc:awsathena://", "AwsRegion", athenaParam.getAwsRegion());
        AthenaConnectionParam athenaConnectionParam = new AthenaConnectionParam();
        athenaConnectionParam.setUser(athenaParam.getUserName());
        athenaConnectionParam.setPassword(PasswordUtils.encodePassword((String)athenaParam.getPassword()));
        athenaConnectionParam.setAwsRegion(athenaParam.getAwsRegion());
        athenaConnectionParam.setOther(athenaParam.getOther());
        athenaConnectionParam.setAddress(address);
        athenaConnectionParam.setJdbcUrl(address);
        athenaConnectionParam.setDatabase(athenaParam.getDatabase());
        athenaConnectionParam.setDriverClassName(this.getDatasourceDriver());
        athenaConnectionParam.setValidationQuery(this.getValidationQuery());
        return athenaConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, AthenaConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.simba.athena.jdbc.Driver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        AthenaConnectionParam athenaConnectionParam = (AthenaConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)athenaConnectionParam.getOther())) {
            return String.format("%s;%s", athenaConnectionParam.getJdbcUrl(), this.transformOther(athenaConnectionParam.getOther()));
        }
        return athenaConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        AthenaConnectionParam athenaConnectionParam = (AthenaConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), athenaConnectionParam.getUser(), PasswordUtils.decodePassword((String)athenaConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.ATHENA;
    }

    public DataSourceProcessor create() {
        return new AthenaDataSourceProcessor();
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isNotEmpty(otherMap)) {
            ArrayList list = new ArrayList(otherMap.size());
            otherMap.forEach((key, value) -> list.add(String.format("%s=%s", key, value)));
            return String.join((CharSequence)";", list);
        }
        return null;
    }

    protected void checkHost(String host) {
    }

    protected void checkDatabasePatter(String database) {
    }
}

