/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosRemoteLogHandler
implements RemoteLogHandler,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CosRemoteLogHandler.class);
    private final COSClient cosClient;
    private final String bucketName;
    private static CosRemoteLogHandler instance;

    private CosRemoteLogHandler() {
        String secretId = PropertyUtils.getString("remote.logging.cos.access.key.id");
        String secretKey = PropertyUtils.getString("remote.logging.cos.access.key.secret");
        BasicCOSCredentials cosCredentials = new BasicCOSCredentials(secretId, secretKey);
        String regionName = PropertyUtils.getString("remote.logging.cos.region");
        ClientConfig clientConfig = new ClientConfig(new Region(regionName));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        this.cosClient = new COSClient((COSCredentials)cosCredentials, clientConfig);
        this.bucketName = PropertyUtils.getString("remote.logging.cos.bucket.name");
        this.checkBucketNameExists(this.bucketName);
    }

    public static synchronized CosRemoteLogHandler getInstance() {
        if (instance == null) {
            instance = new CosRemoteLogHandler();
        }
        return instance;
    }

    @Override
    public void sendRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("send remote log from {} to tencent cos {}", (Object)logPath, (Object)objectName);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, objectName, new File(logPath));
            this.cosClient.putObject(putObjectRequest);
        }
        catch (Exception e) {
            log.error("error while sending remote log from {} to tencent cos {}, reason:", new Object[]{logPath, objectName, e});
        }
    }

    @Override
    public void getRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("get remote log from tencent cos {} to {}", (Object)objectName, (Object)logPath);
            this.cosClient.getObject(new GetObjectRequest(this.bucketName, objectName), new File(logPath));
        }
        catch (Exception e) {
            log.error("error while sending remote log from {} to tencent cos {}, reason:", new Object[]{objectName, logPath, e});
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cosClient != null) {
            this.cosClient.shutdown();
        }
    }

    private void checkBucketNameExists(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("remote.logging.cos.bucket.name is empty");
        }
        boolean existsBucket = this.cosClient.doesBucketExist(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " does not exists, you should create it first");
        }
        log.debug("tencent cos bucket {} has been found for remote logging", (Object)bucketName);
    }
}

