/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.workflow;

import lombok.Generated;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowTriggerRequest;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.utils.WorkflowUtils;
import org.apache.dolphinscheduler.api.validator.ITransformer;
import org.apache.dolphinscheduler.api.validator.workflow.TriggerWorkflowDTO;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionDao;
import org.apache.dolphinscheduler.plugin.task.api.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TriggerWorkflowRequestTransformer
implements ITransformer<WorkflowTriggerRequest, TriggerWorkflowDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TriggerWorkflowRequestTransformer.class);
    @Autowired
    private WorkflowDefinitionDao workflowDefinitionDao;

    @Override
    public TriggerWorkflowDTO transform(WorkflowTriggerRequest workflowTriggerRequest) {
        TriggerWorkflowDTO triggerWorkflowDTO = TriggerWorkflowDTO.builder().loginUser(workflowTriggerRequest.getLoginUser()).startNodes(WorkflowUtils.parseStartNodeList(workflowTriggerRequest.getStartNodes())).failureStrategy(workflowTriggerRequest.getFailureStrategy()).taskDependType(workflowTriggerRequest.getTaskDependType()).execType(workflowTriggerRequest.getExecType()).warningType(workflowTriggerRequest.getWarningType()).warningGroupId(workflowTriggerRequest.getWarningGroupId()).workflowInstancePriority(workflowTriggerRequest.getWorkflowInstancePriority()).workerGroup(workflowTriggerRequest.getWorkerGroup()).tenantCode(workflowTriggerRequest.getTenantCode()).environmentCode(workflowTriggerRequest.getEnvironmentCode()).startParamList(PropertyUtils.startParamsTransformPropertyList((String)workflowTriggerRequest.getStartParamList())).dryRun(workflowTriggerRequest.getDryRun()).testFlag(workflowTriggerRequest.getTestFlag()).build();
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)this.workflowDefinitionDao.queryByCode(workflowTriggerRequest.getWorkflowDefinitionCode()).orElseThrow(() -> new ServiceException("Cannot find the workflow: " + workflowTriggerRequest.getWorkflowDefinitionCode()));
        triggerWorkflowDTO.setWorkflowDefinition(workflowDefinition);
        return triggerWorkflowDTO;
    }
}

