/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.MetricsCleanUpService;
import org.apache.dolphinscheduler.api.service.SessionService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.EncryptionUtils;
import org.apache.dolphinscheduler.dao.entity.AlertGroup;
import org.apache.dolphinscheduler.dao.entity.DatasourceUser;
import org.apache.dolphinscheduler.dao.entity.K8sNamespaceUser;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AccessTokenMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.K8sNamespaceUserMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectUserMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsersServiceImpl
extends BaseServiceImpl
implements UsersService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsersServiceImpl.class);
    @Autowired
    private AccessTokenMapper accessTokenMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ProjectUserMapper projectUserMapper;
    @Autowired
    private DataSourceUserMapper datasourceUserMapper;
    @Autowired
    private AlertGroupMapper alertGroupMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired(required=false)
    private StorageOperator storageOperator;
    @Autowired
    private K8sNamespaceUserMapper k8sNamespaceUserMapper;
    @Autowired
    private MetricsCleanUpService metricsCleanUpService;
    @Autowired
    private SessionService sessionService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> createUser(User loginUser, String userName, String userPassword, String email, int tenantId, String phone, String queue, int state) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = this.checkUserParams(userName, userPassword, email, phone);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, msg);
            return result;
        }
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, msg);
            return result;
        }
        if (!this.checkTenantExists(tenantId)) {
            log.warn("Tenant does not exist, tenantId:{}.", (Object)tenantId);
            this.putMsg(result, Status.TENANT_NOT_EXIST, new Object[0]);
            return result;
        }
        User user = this.createUser(userName, userPassword, email, tenantId, phone, queue, state);
        log.info("User is created and id is {}.", (Object)user.getId());
        result.put("data", user);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public User createUser(String userName, String userPassword, String email, int tenantId, String phone, String queue, int state) {
        User user = new User();
        Date now = new Date();
        user.setUserName(userName);
        user.setUserPassword(EncryptionUtils.getMd5((String)userPassword));
        user.setEmail(email);
        user.setTenantId(tenantId);
        user.setPhone(phone);
        user.setState(state);
        user.setUserType(UserType.GENERAL_USER);
        user.setCreateTime(now);
        user.setUpdateTime(now);
        if (StringUtils.isEmpty((CharSequence)queue)) {
            queue = "";
        }
        user.setQueue(queue);
        this.userMapper.insert((Object)user);
        return user;
    }

    @Override
    @Transactional
    public User createUser(UserType userType, String userId, String email) {
        User user = new User();
        Date now = new Date();
        user.setUserName(userId);
        user.setEmail(email);
        user.setUserType(userType);
        user.setCreateTime(now);
        user.setUpdateTime(now);
        user.setTenantId(-1);
        user.setQueue("");
        user.setState(Flag.YES.getCode());
        this.userMapper.insert((Object)user);
        return user;
    }

    @Override
    public User getUserByUserName(String userName) {
        return this.userMapper.queryByUserNameAccurately(userName);
    }

    @Override
    public User queryUser(int id) {
        return this.userMapper.selectById(id);
    }

    @Override
    public List<User> queryUser(List<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<User>();
        }
        return this.userMapper.selectByIds(ids);
    }

    @Override
    public User queryUser(String name) {
        return this.userMapper.queryByUserNameAccurately(name);
    }

    @Override
    public User queryUser(String name, String password) {
        String md5 = EncryptionUtils.getMd5((String)password);
        return this.userMapper.queryUserByNamePassword(name, md5);
    }

    @Override
    public int getUserIdByName(String name) {
        int executorId = 0;
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            User executor = this.queryUser(name);
            executorId = null != executor ? executor.getId() : -1;
        }
        return executorId;
    }

    @Override
    public Result<Object> queryUserList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result<Object> result = new Result<Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg((Result)result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (!this.isAdmin(loginUser)) {
            log.warn("User does not have permission for this feature, userId:{}, userName:{}.", (Object)loginUser.getId(), (Object)loginUser.getUserName());
            this.putMsg((Result)result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage scheduleList = this.userMapper.queryUserPaging(page, searchVal);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)scheduleList.getTotal());
        pageInfo.setTotalList(scheduleList.getRecords());
        result.setData(pageInfo);
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public User updateUser(User loginUser, Integer userId, String userName, String userPassword, String email, Integer tenantId, String phone, String queue, int state, String timeZone) {
        if (this.resourcePermissionCheckService.functionDisabled()) {
            throw new ServiceException(Status.FUNCTION_DISABLED);
        }
        if (!this.canOperator(loginUser, userId)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        User user = (User)this.userMapper.selectById((Serializable)userId);
        if (user == null) {
            throw new ServiceException(Status.USER_NOT_EXIST, userId);
        }
        if (!this.isAdmin(loginUser)) {
            if (tenantId != null && user.getTenantId() != tenantId.intValue()) {
                throw new ServiceException(Status.USER_NO_OPERATION_PERM);
            }
            if (StringUtils.isNotEmpty((CharSequence)queue) && !StringUtils.equals((CharSequence)queue, (CharSequence)user.getQueue())) {
                throw new ServiceException(Status.USER_NO_OPERATION_PERM);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            if (!CheckUtils.checkUserName(userName)) {
                throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, userName);
            }
            User tempUser = this.userMapper.queryByUserNameAccurately(userName);
            if (tempUser != null && !userId.equals(tempUser.getId())) {
                throw new ServiceException(Status.USER_NAME_EXIST);
            }
            user.setUserName(userName);
        }
        if (StringUtils.isNotEmpty((CharSequence)userPassword)) {
            if (!CheckUtils.checkPasswordLength(userPassword)) {
                throw new ServiceException(Status.USER_PASSWORD_LENGTH_ERROR);
            }
            user.setUserPassword(EncryptionUtils.getMd5((String)userPassword));
            this.sessionService.expireSession(user.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            if (!CheckUtils.checkEmail(email)) {
                throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, email);
            }
            user.setEmail(email);
        }
        if (StringUtils.isNotEmpty((CharSequence)phone) && !CheckUtils.checkPhone(phone)) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, phone);
        }
        if (state == 0 && user.getState() != state && Objects.equals(loginUser.getId(), user.getId())) {
            throw new ServiceException(Status.NOT_ALLOW_TO_DISABLE_OWN_ACCOUNT);
        }
        if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
            if (!CheckUtils.checkTimeZone(timeZone)) {
                throw new ServiceException(Status.TIME_ZONE_ILLEGAL, timeZone);
            }
            user.setTimeZone(timeZone);
        }
        user.setPhone(phone);
        user.setQueue(queue);
        user.setState(state);
        user.setUpdateTime(new Date());
        user.setTenantId(tenantId.intValue());
        if (this.userMapper.updateById(user) <= 0) {
            throw new ServiceException(Status.UPDATE_USER_ERROR);
        }
        return user;
    }

    @Override
    @Transactional
    public Map<String, Object> deleteUserById(User loginUser, int id) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (!this.isAdmin(loginUser)) {
            log.warn("User does not have permission for this feature, userId:{}, userName:{}.", (Object)loginUser.getId(), (Object)loginUser.getUserName());
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, id);
            return result;
        }
        User tempUser = this.userMapper.selectById(id);
        if (tempUser == null) {
            log.error("User does not exist, userId:{}.", (Object)id);
            this.putMsg(result, Status.USER_NOT_EXIST, id);
            return result;
        }
        List projects = this.projectMapper.queryProjectCreatedByUser(id);
        if (CollectionUtils.isNotEmpty((Collection)projects)) {
            String projectNames = projects.stream().map(Project::getName).collect(Collectors.joining(","));
            this.putMsg(result, Status.TRANSFORM_PROJECT_OWNERSHIP, projectNames);
            log.warn("Please transfer the project ownership before deleting the user, userId:{}, projects:{}.", (Object)id, (Object)projectNames);
            return result;
        }
        this.userMapper.queryTenantCodeByUserId(id);
        this.accessTokenMapper.deleteAccessTokenByUserId(id);
        this.sessionService.expireSession(id);
        if (this.userMapper.deleteById(id) > 0) {
            this.metricsCleanUpService.cleanUpApiResponseTimeMetricsByUserId(id);
            log.info("User is deleted and id is :{}.", (Object)id);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        log.error("User delete error, userId:{}.", (Object)id);
        this.putMsg(result, Status.DELETE_USER_BY_ID_ERROR, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> revokeProjectById(User loginUser, int userId, String projectIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            return result;
        }
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        Arrays.stream(projectIds.split(",")).distinct().forEach(projectId -> {
            Project project = this.projectMapper.queryDetailById(Integer.parseInt(projectId));
            if (project == null) {
                this.putMsg(result, Status.PROJECT_NOT_FOUND, Integer.parseInt(projectId));
            } else {
                this.projectUserMapper.deleteProjectRelation(project.getId().intValue(), user.getId().intValue());
            }
        });
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> grantProjectWithReadPerm(User loginUser, int userId, String projectIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        User tempUser = this.userMapper.selectById(userId);
        if (tempUser == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        if (this.check(result, StringUtils.isEmpty((CharSequence)projectIds), Status.SUCCESS)) {
            return result;
        }
        Arrays.stream(projectIds.split(",")).distinct().forEach(projectId -> {
            ProjectUser projectUserOld = this.projectUserMapper.queryProjectRelation(Integer.parseInt(projectId), userId);
            if (projectUserOld != null) {
                this.projectUserMapper.deleteProjectRelation(Integer.parseInt(projectId), userId);
            }
            Date now = new Date();
            ProjectUser projectUser = new ProjectUser();
            projectUser.setUserId(userId);
            projectUser.setProjectId(Integer.parseInt(projectId));
            projectUser.setPerm(2);
            projectUser.setCreateTime(now);
            projectUser.setUpdateTime(now);
            this.projectUserMapper.insert((Object)projectUser);
        });
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> grantProject(User loginUser, int userId, String projectIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        User tempUser = this.userMapper.selectById(userId);
        if (tempUser == null) {
            log.error("User does not exist, userId:{}.", (Object)userId);
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        if (this.check(result, StringUtils.isEmpty((CharSequence)projectIds), Status.SUCCESS)) {
            log.warn("Parameter projectIds is empty.");
            return result;
        }
        Arrays.stream(projectIds.split(",")).distinct().forEach(projectId -> {
            ProjectUser projectUserOld = this.projectUserMapper.queryProjectRelation(Integer.parseInt(projectId), userId);
            if (projectUserOld != null) {
                this.projectUserMapper.deleteProjectRelation(Integer.parseInt(projectId), userId);
            }
            Date now = new Date();
            ProjectUser projectUser = new ProjectUser();
            projectUser.setUserId(userId);
            projectUser.setProjectId(Integer.parseInt(projectId));
            projectUser.setPerm(7);
            projectUser.setCreateTime(now);
            projectUser.setUpdateTime(now);
            this.projectUserMapper.insert((Object)projectUser);
        });
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> grantProjectByCode(User loginUser, int userId, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        User tempUser = this.userMapper.selectById(userId);
        if (tempUser == null) {
            log.error("User does not exist, userId:{}.", (Object)userId);
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            log.error("Project does not exist, projectCode:{}.", (Object)projectCode);
            this.putMsg(result, Status.PROJECT_NOT_FOUND, projectCode);
            return result;
        }
        if (!this.canOperator(loginUser, project.getUserId())) {
            log.warn("User does not have permission for project, userId:{}, userName:{}, projectCode:{}.", new Object[]{loginUser.getId(), loginUser.getUserName(), projectCode});
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        ProjectUser projectUser = this.projectUserMapper.queryProjectRelation(project.getId().intValue(), userId);
        if (projectUser == null) {
            Date today = new Date();
            projectUser = new ProjectUser();
            projectUser.setUserId(userId);
            projectUser.setProjectId(project.getId().intValue());
            projectUser.setPerm(7);
            projectUser.setCreateTime(today);
            projectUser.setUpdateTime(today);
            this.projectUserMapper.insert((Object)projectUser);
        }
        log.info("User is granted permission for projects, userId:{}, projectCode:{}.", (Object)userId, (Object)projectCode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> revokeProject(User loginUser, int userId, long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            log.warn("Only admin can revoke the project permission.");
            return result;
        }
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            log.error("User does not exist, userId:{}.", (Object)userId);
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            log.error("Project does not exist, projectCode:{}.", (Object)projectCode);
            this.putMsg(result, Status.PROJECT_NOT_FOUND, projectCode);
            return result;
        }
        this.projectUserMapper.deleteProjectRelation(project.getId().intValue(), user.getId().intValue());
        log.info("User is revoked permission for projects, userId:{}, projectCode:{}.", (Object)userId, (Object)projectCode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> grantNamespaces(User loginUser, int userId, String namespaceIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            log.warn("Only admin can grant namespaces.");
            return result;
        }
        User tempUser = this.userMapper.selectById(userId);
        if (tempUser == null) {
            log.error("User does not exist, userId:{}.", (Object)userId);
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        this.k8sNamespaceUserMapper.deleteNamespaceRelation(0, userId);
        if (StringUtils.isNotEmpty((CharSequence)namespaceIds)) {
            String[] namespaceIdArr;
            for (String namespaceId : namespaceIdArr = namespaceIds.split(",")) {
                Date now = new Date();
                K8sNamespaceUser namespaceUser = new K8sNamespaceUser();
                namespaceUser.setUserId(userId);
                namespaceUser.setNamespaceId(Integer.parseInt(namespaceId));
                namespaceUser.setPerm(7);
                namespaceUser.setCreateTime(now);
                namespaceUser.setUpdateTime(now);
                this.k8sNamespaceUserMapper.insert((Object)namespaceUser);
            }
        }
        log.info("User is granted permission for namespace, userId:{}.", (Object)tempUser.getId());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> grantDataSource(User loginUser, int userId, String datasourceIds) {
        String[] datasourceIdArr;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            log.warn("Only admin can grant datasource.");
            return result;
        }
        User user = this.userMapper.selectById(userId);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userId);
            return result;
        }
        this.datasourceUserMapper.deleteByUserId(userId);
        if (this.check(result, StringUtils.isEmpty((CharSequence)datasourceIds), Status.SUCCESS)) {
            return result;
        }
        for (String datasourceId : datasourceIdArr = datasourceIds.split(",")) {
            Date now = new Date();
            DatasourceUser datasourceUser = new DatasourceUser();
            datasourceUser.setUserId(userId);
            datasourceUser.setDatasourceId(Integer.parseInt(datasourceId));
            datasourceUser.setPerm(7);
            datasourceUser.setCreateTime(now);
            datasourceUser.setUpdateTime(now);
            this.datasourceUserMapper.insert((Object)datasourceUser);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> getUserInfo(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        User user = null;
        if (loginUser.getUserType() == UserType.ADMIN_USER) {
            user = loginUser;
        } else {
            user = this.userMapper.queryDetailsById(loginUser.getId().intValue());
            List alertGroups = this.alertGroupMapper.queryByUserId(loginUser.getId().intValue());
            StringBuilder sb = new StringBuilder();
            if (alertGroups != null && !alertGroups.isEmpty()) {
                for (int i = 0; i < alertGroups.size() - 1; ++i) {
                    sb.append(((AlertGroup)alertGroups.get(i)).getGroupName()).append(",");
                }
                sb.append(alertGroups.get(alertGroups.size() - 1));
                user.setAlertGroup(sb.toString());
            }
        }
        Tenant tenant = (Tenant)this.tenantMapper.selectById((Serializable)Integer.valueOf(user.getTenantId()));
        if (tenant != null) {
            user.setTenantCode(tenant.getTenantCode());
        }
        if (StringUtils.isEmpty((CharSequence)user.getTimeZone())) {
            user.setTimeZone(TimeZone.getDefault().toZoneId().getId());
        }
        user.setUserPassword(null);
        result.put("data", user);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllGeneralUsers(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            log.warn("Only admin can query all general users.");
            return result;
        }
        List userList = this.userMapper.queryAllGeneralUser();
        result.put("data", userList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryUserList(User loginUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ACCESS_TOKEN, "security:user:view")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        List userList = this.userMapper.queryEnabledUsers();
        result.put("data", userList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyUserName(String userName) {
        Result<Object> result = new Result<Object>();
        User user = this.userMapper.queryByUserNameAccurately(userName);
        if (user != null) {
            this.putMsg((Result)result, Status.USER_NAME_EXIST, new Object[0]);
        } else {
            this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> unauthorizedUser(User loginUser, Integer alertgroupId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            log.warn("Only admin can deauthorize user.");
            return result;
        }
        List userList = this.userMapper.selectList(null);
        ArrayList resultUsers = new ArrayList();
        HashSet userSet = null;
        if (userList != null && !userList.isEmpty()) {
            userSet = new HashSet(userList);
            List authedUserList = this.userMapper.queryUserListByAlertGroupId(alertgroupId.intValue());
            HashSet authedUserSet = null;
            if (authedUserList != null && !authedUserList.isEmpty()) {
                authedUserSet = new HashSet(authedUserList);
                userSet.removeAll(authedUserSet);
            }
            resultUsers = new ArrayList(userSet);
        }
        result.put("data", resultUsers);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> authorizedUser(User loginUser, Integer alertGroupId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (this.check(result, !this.isAdmin(loginUser), Status.USER_NO_OPERATION_PERM)) {
            log.warn("Only admin can authorize user.");
            return result;
        }
        List userList = this.userMapper.queryUserListByAlertGroupId(alertGroupId.intValue());
        result.put("data", userList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkTenantExists(int tenantId) {
        return this.tenantMapper.queryById(tenantId) != null;
    }

    private String checkUserParams(String userName, String password, String email, String phone) {
        String msg = null;
        if (!CheckUtils.checkUserName(userName)) {
            log.warn("Parameter userName check failed.");
            msg = userName;
        } else if (!CheckUtils.checkPassword(password)) {
            log.warn("Parameter password check failed.");
            msg = password;
        } else if (!CheckUtils.checkEmail(email)) {
            log.warn("Parameter email check failed.");
            msg = email;
        } else if (!CheckUtils.checkPhone(phone)) {
            log.warn("Parameter phone check failed.");
            msg = phone;
        }
        return msg;
    }

    @Override
    @Transactional
    public Map<String, Object> registerUser(String userName, String userPassword, String repeatPassword, String email) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = this.checkUserParams(userName, userPassword, email, "");
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, msg);
            return result;
        }
        if (!userPassword.equals(repeatPassword)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "two passwords are not same");
            return result;
        }
        User user = this.createUser(userName, userPassword, email, -1, "", "", Flag.NO.ordinal());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", user);
        return result;
    }

    @Override
    public Map<String, Object> activateUser(User loginUser, String userName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", false);
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (!CheckUtils.checkUserName(userName)) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, userName);
            return result;
        }
        User user = this.userMapper.queryByUserNameAccurately(userName);
        if (user == null) {
            this.putMsg(result, Status.USER_NOT_EXIST, userName);
            return result;
        }
        if (user.getState() != Flag.NO.ordinal()) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, userName);
            return result;
        }
        user.setState(Flag.YES.ordinal());
        Date now = new Date();
        user.setUpdateTime(now);
        this.userMapper.updateById(user);
        User responseUser = this.userMapper.queryByUserNameAccurately(userName);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", responseUser);
        return result;
    }

    @Override
    public Map<String, Object> batchActivateUser(User loginUser, List<String> userNames) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.resourcePermissionCheckService.functionDisabled()) {
            this.putMsg(result, Status.FUNCTION_DISABLED, new Object[0]);
            return result;
        }
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        int totalSuccess = 0;
        ArrayList<String> successUserNames = new ArrayList<String>();
        HashMap<String, Serializable> successRes = new HashMap<String, Serializable>();
        int totalFailed = 0;
        ArrayList failedInfo = new ArrayList();
        HashMap<String, Serializable> failedRes = new HashMap<String, Serializable>();
        for (String userName : userNames) {
            Map<String, Object> tmpResult = this.activateUser(loginUser, userName);
            if (tmpResult.get("status") != Status.SUCCESS) {
                ++totalFailed;
                HashMap<String, String> failedBody = new HashMap<String, String>();
                failedBody.put("userName", userName);
                Status status = (Status)((Object)tmpResult.get("status"));
                String errorMessage = MessageFormat.format(status.getMsg(), userName);
                failedBody.put("msg", errorMessage);
                failedInfo.add(failedBody);
                continue;
            }
            ++totalSuccess;
            successUserNames.add(userName);
        }
        successRes.put("sum", Integer.valueOf(totalSuccess));
        successRes.put("userName", successUserNames);
        failedRes.put("sum", Integer.valueOf(totalFailed));
        failedRes.put("info", failedInfo);
        HashMap<String, HashMap<String, Serializable>> res = new HashMap<String, HashMap<String, Serializable>>();
        res.put("success", successRes);
        res.put("failed", failedRes);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", res);
        return result;
    }

    @Override
    @Transactional
    public User createUserIfNotExists(String userName, String userPassword, String email, String phone, String tenantCode, String queue, int state) {
        User user = this.userMapper.queryByUserNameAccurately(userName);
        if (Objects.isNull(user)) {
            Tenant tenant = this.tenantMapper.queryByTenantCode(tenantCode);
            user = this.createUser(userName, userPassword, email, tenant.getId(), phone, queue, state);
            return user;
        }
        this.updateUser(user, user.getId(), userName, userPassword, email, user.getTenantId(), phone, queue, state, null);
        user = this.userMapper.queryDetailsById(user.getId().intValue());
        return user;
    }
}

