/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.k8s.K8sClientService;
import org.apache.dolphinscheduler.api.service.K8sNamespaceService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.Cluster;
import org.apache.dolphinscheduler.dao.entity.K8sNamespace;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ClusterMapper;
import org.apache.dolphinscheduler.dao.mapper.K8sNamespaceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class K8SNamespaceServiceImpl
extends BaseServiceImpl
implements K8sNamespaceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8SNamespaceServiceImpl.class);
    @Autowired
    private K8sNamespaceMapper k8sNamespaceMapper;
    @Autowired
    private K8sClientService k8sClientService;
    @Autowired
    private ClusterMapper clusterMapper;

    @Override
    public Result queryListPaging(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        if (!this.isAdmin(loginUser)) {
            log.warn("Only admin can query namespace list, current login user name:{}.", (Object)loginUser.getUserName());
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage k8sNamespaceList = this.k8sNamespaceMapper.queryK8sNamespacePaging((IPage)page, searchVal);
        Integer count = (int)k8sNamespaceList.getTotal();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal(count);
        pageInfo.setTotalList(k8sNamespaceList.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> registerK8sNamespace(User loginUser, String namespace, Long clusterCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            log.warn("Parameter namespace is empty.");
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "namespace");
            return result;
        }
        if (clusterCode == null) {
            log.warn("Parameter clusterCode is null.");
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "cluster");
            return result;
        }
        if (this.checkNamespaceExistInDb(namespace, clusterCode)) {
            log.warn("K8S namespace already exists.");
            this.putMsg(result, Status.K8S_NAMESPACE_EXIST, namespace, clusterCode);
            return result;
        }
        Cluster cluster = this.clusterMapper.queryByClusterCode(clusterCode);
        if (cluster == null) {
            log.error("Cluster does not exist, clusterCode:{}", (Object)clusterCode);
            this.putMsg(result, Status.CLUSTER_NOT_EXISTS, namespace, clusterCode);
            return result;
        }
        long code = 0L;
        try {
            code = CodeGenerateUtils.genCode();
            cluster.setCode(Long.valueOf(code));
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("Generate cluster code error.", (Throwable)e);
        }
        if (code == 0L) {
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating cluster code");
            return result;
        }
        K8sNamespace k8sNamespaceObj = new K8sNamespace();
        Date now = new Date();
        k8sNamespaceObj.setCode(Long.valueOf(code));
        k8sNamespaceObj.setNamespace(namespace);
        k8sNamespaceObj.setClusterCode(clusterCode);
        k8sNamespaceObj.setUserId(loginUser.getId().intValue());
        k8sNamespaceObj.setCreateTime(now);
        k8sNamespaceObj.setUpdateTime(now);
        if (!Constants.K8S_LOCAL_TEST_CLUSTER_CODE.equals(k8sNamespaceObj.getClusterCode())) {
            try {
                this.k8sClientService.upsertNamespaceAndResourceToK8s(k8sNamespaceObj);
            }
            catch (Exception e) {
                log.error("Namespace create to k8s error", (Throwable)e);
                this.putMsg(result, Status.K8S_CLIENT_OPS_ERROR, e.getMessage());
                return result;
            }
        }
        this.k8sNamespaceMapper.insert((Object)k8sNamespaceObj);
        log.info("K8s namespace create complete, namespace:{}.", (Object)k8sNamespaceObj.getNamespace());
        result.put("data", k8sNamespaceObj);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result<Object> verifyNamespaceK8s(String namespace, Long clusterCode) {
        Result<Object> result = new Result<Object>();
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            log.warn("Parameter namespace is empty.");
            this.putMsg((Result)result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[]{"namespace"});
            return result;
        }
        if (clusterCode == null) {
            log.warn("Parameter clusterCode is null.");
            this.putMsg((Result)result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, new Object[]{"cluster"});
            return result;
        }
        if (this.checkNamespaceExistInDb(namespace, clusterCode)) {
            log.warn("K8S namespace already exists.");
            this.putMsg((Result)result, Status.K8S_NAMESPACE_EXIST, new Object[]{namespace, clusterCode});
            return result;
        }
        this.putMsg((Result)result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> deleteNamespaceById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNotAdmin(loginUser)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        K8sNamespace k8sNamespaceObj = (K8sNamespace)this.k8sNamespaceMapper.selectById((Serializable)Integer.valueOf(id));
        if (k8sNamespaceObj == null) {
            log.error("K8s namespace does not exist, namespaceId:{}.", (Object)id);
            this.putMsg(result, Status.K8S_NAMESPACE_NOT_EXIST, id);
            return result;
        }
        this.k8sNamespaceMapper.deleteById((Serializable)Integer.valueOf(id));
        log.info("K8s namespace delete complete, namespace:{}.", (Object)k8sNamespaceObj.getNamespace());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private boolean checkNamespaceExistInDb(String namespace, Long clusterCode) {
        return this.k8sNamespaceMapper.existNamespace(namespace, clusterCode) == Boolean.TRUE;
    }

    @Override
    public Map<String, Object> queryUnauthorizedNamespace(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (loginUser.getId() != userId && this.isNotAdmin(loginUser)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        List namespaceList = this.k8sNamespaceMapper.selectList(null);
        List<Object> resultList = new ArrayList();
        if (namespaceList != null && !namespaceList.isEmpty()) {
            HashSet<K8sNamespace> namespaceSet = new HashSet<K8sNamespace>(namespaceList);
            List authedProjectList = this.k8sNamespaceMapper.queryAuthedNamespaceListByUserId(userId);
            resultList = this.getUnauthorizedNamespaces(namespaceSet, authedProjectList);
        }
        result.put("data", resultList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAuthorizedNamespace(User loginUser, Integer userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (loginUser.getId() != userId && this.isNotAdmin(loginUser)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        List namespaces = this.k8sNamespaceMapper.queryAuthedNamespaceListByUserId(userId);
        result.put("data", namespaces);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<K8sNamespace> queryNamespaceAvailable(User loginUser) {
        List k8sNamespaces = this.isAdmin(loginUser) ? this.k8sNamespaceMapper.selectList(null) : this.k8sNamespaceMapper.queryAuthedNamespaceListByUserId(loginUser.getId());
        this.setClusterName(k8sNamespaces);
        return k8sNamespaces;
    }

    private void setClusterName(List<K8sNamespace> k8sNamespaces) {
        List clusters;
        if (CollectionUtils.isNotEmpty(k8sNamespaces) && CollectionUtils.isNotEmpty((Collection)(clusters = this.clusterMapper.queryAllClusterList()))) {
            Map<Long, String> codeNameMap = clusters.stream().collect(Collectors.toMap(Cluster::getCode, Cluster::getName, (a, b) -> a));
            for (K8sNamespace k8sNamespace : k8sNamespaces) {
                String clusterName = codeNameMap.get(k8sNamespace.getClusterCode());
                k8sNamespace.setClusterName(clusterName);
            }
        }
    }

    private List<K8sNamespace> getUnauthorizedNamespaces(Set<K8sNamespace> namespaceSet, List<K8sNamespace> authedNamespaceList) {
        ArrayList<K8sNamespace> resultList = new ArrayList<K8sNamespace>();
        for (K8sNamespace k8sNamespace : namespaceSet) {
            boolean existAuth = false;
            if (authedNamespaceList != null && !authedNamespaceList.isEmpty()) {
                for (K8sNamespace k8sNamespaceAuth : authedNamespaceList) {
                    if (!k8sNamespace.equals((Object)k8sNamespaceAuth)) continue;
                    existAuth = true;
                }
            }
            if (existAuth) continue;
            resultList.add(k8sNamespace);
        }
        return resultList;
    }
}

