/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.maven.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.maven.plugins.AbstractStudioMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioEclipseMojo
extends AbstractStudioMojo {
    public static final String ENTRY_BUNDLE_CLASSPATH = "Bundle-ClassPath:";
    public static final String ENTRY_BUNDLE_SYMBOLICNAME = "Bundle-SymbolicName:";
    public static final String ENTRY_BUNDLE_VERSION = "Bundle-Version:";
    protected boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.project.isExecutionRoot()) {
            try {
                this.forkMvnGoal("eclipse:eclipse", this.getActiveProfileIds(), this.getInactiveProfileIds());
                this.forkMvnGoal("process-classes", this.getActiveProfileIds(), this.getInactiveProfileIds());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        if (!this.skip) {
            try {
                List<Artifact> artifactList = this.createArtifactList();
                this.copyArtifacts(artifactList);
                this.updateDotClasspath(artifactList);
                this.updateDotProject();
                this.removeMavenEclipseXml();
                this.removeDotExternalToolBuilders();
            }
            catch (FileNotFoundException e) {
                this.getLog().error((CharSequence)"Please run eclipse:eclipse first to create .classpath, e.g. mvn eclipse:eclipse studio:eclipse.", (Throwable)e);
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    private void copyArtifacts(List<Artifact> list) throws IOException {
        if (!list.isEmpty()) {
            File copyDir = new File(this.project.getBasedir(), this.libraryPath);
            if (!copyDir.exists() && !copyDir.mkdirs()) {
                throw new IOException("Failed to create directory " + copyDir);
            }
            for (Artifact artifact : list) {
                if (artifact.getScope().equalsIgnoreCase("test")) continue;
                File destFile = new File(copyDir, artifact.getFile().getName());
                FileUtils.copyFile((File)artifact.getFile(), (File)destFile);
                this.getLog().info((CharSequence)("Copying " + artifact.getFile() + " to " + destFile));
            }
        }
    }

    private void updateDotClasspath(List<Artifact> list) throws IOException, XmlPullParserException {
        this.getLog().info((CharSequence)("Update .classpath in " + this.project.getBasedir()));
        FileInputStream is = new FileInputStream(new File(this.project.getBasedir(), ".classpath"));
        Xpp3Dom dom = Xpp3DomBuilder.build((InputStream)is, (String)"UTF-8");
        int cnt = 0;
        for (Xpp3Dom cpEntry : dom.getChildren("classpathentry")) {
            if (cpEntry.getAttribute("kind").equals("lib")) {
                dom.removeChild(cnt);
                --cnt;
            }
            ++cnt;
        }
        for (Artifact artifact : list) {
            Xpp3Dom entry;
            if (artifact.getScope().equalsIgnoreCase("test")) {
                entry = new Xpp3Dom("classpathentry");
                entry.setAttribute("kind", "lib");
                entry.setAttribute("path", this.libraryPath + '/' + artifact.getFile().getName());
            } else {
                entry = new Xpp3Dom("classpathentry");
                entry.setAttribute("exported", "true");
                entry.setAttribute("kind", "lib");
                entry.setAttribute("path", this.libraryPath + '/' + artifact.getFile().getName());
            }
            dom.addChild(entry);
        }
        ((InputStream)is).close();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.project.getBasedir(), ".classpath")), "UTF-8");
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        Xpp3DomWriter.write((XMLWriter)writer, (Xpp3Dom)dom);
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    private void updateDotProject() throws IOException, XmlPullParserException {
        this.getLog().info((CharSequence)("Update .project in " + this.project.getBasedir()));
        FileInputStream is = new FileInputStream(new File(this.project.getBasedir(), ".project"));
        Xpp3Dom dom = Xpp3DomBuilder.build((InputStream)is, (String)"UTF-8");
        int cnt = 0;
        for (Xpp3Dom cpEntry : dom.getChild("buildSpec").getChildren("buildCommand")) {
            if (cpEntry.getChild("name").getValue().equals("org.eclipse.ui.externaltools.ExternalToolBuilder")) {
                dom.getChild("buildSpec").removeChild(cnt);
                --cnt;
            }
            ++cnt;
        }
        this.removeChildFromDom(dom, "linkedResources");
        this.removeChildFromDom(dom, "projects");
        ((InputStream)is).close();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.project.getBasedir(), ".project")), "UTF-8");
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        Xpp3DomWriter.write((XMLWriter)writer, (Xpp3Dom)dom);
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    void removeMavenEclipseXml() throws IOException {
        File file = new File(this.project.getBasedir(), "maven-eclipse.xml");
        if (file.exists() && !file.delete()) {
            throw new IOException("Failed to delete file " + file);
        }
    }

    void removeDotExternalToolBuilders() {
        File file = new File(this.project.getBasedir(), ".externalToolBuilders");
        if (file.exists()) {
            StudioEclipseMojo.deleteDirectory(file);
        }
    }

    private void removeChildFromDom(Xpp3Dom dom, String childName) {
        int cnt = 0;
        for (Xpp3Dom child : dom.getChildren()) {
            if (child.getName().equals(childName)) {
                dom.removeChild(cnt);
                --cnt;
            }
            ++cnt;
        }
    }
}

