/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.Collection;
import java.util.HashSet;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ACIItem {
    private String identificationTag;
    private int precedence = 0;
    private AuthenticationLevel authenticationLevel;

    protected ACIItem(String identificationTag, int precedence, AuthenticationLevel authenticationLevel) {
        if (identificationTag == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04001_NULL_IDENTIFICATION_TAG, (Object[])new Object[0]));
        }
        if (precedence < 0 || precedence > 255) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04002_BAD_PRECENDENCE, (Object[])new Object[]{precedence}));
        }
        if (authenticationLevel == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04003_NULL_AUTHENTICATION_LEVEL, (Object[])new Object[0]));
        }
        this.identificationTag = identificationTag;
        this.precedence = precedence;
        this.authenticationLevel = authenticationLevel;
    }

    public String getIdentificationTag() {
        return this.identificationTag;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public abstract Collection<ACITuple> toTuples();

    protected static Collection<MicroOperation> toMicroOperations(Collection<GrantAndDenial> grantsAndDenials) {
        HashSet<MicroOperation> microOps = new HashSet<MicroOperation>();
        for (GrantAndDenial grantAndDenial : grantsAndDenials) {
            microOps.add(grantAndDenial.getMicroOperation());
        }
        return microOps;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("identificationTag \"");
        buf.append(this.getIdentificationTag());
        buf.append("\", precedence ");
        buf.append(this.getPrecedence());
        buf.append(", authenticationLevel ");
        buf.append(this.getAuthenticationLevel().getName());
        return buf.toString();
    }
}

