/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.shared.ldap.message.ArrayNamingEnumeration;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.IteratorNamingEnumeration;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesImpl
implements Attributes {
    static final transient long serialVersionUID = 1L;
    private Map<String, AttributeImpl> keyMap;

    public AttributesImpl() {
        this.keyMap = new HashMap<String, AttributeImpl>();
    }

    public AttributesImpl(boolean ignoreCase) {
        this.keyMap = new HashMap<String, AttributeImpl>();
    }

    public AttributesImpl(String id, Object value) {
        this.keyMap = new HashMap<String, AttributeImpl>();
        this.put(id, value);
    }

    public AttributesImpl(String id, Object value, boolean ignoreCase) {
        this.keyMap = new HashMap<String, AttributeImpl>();
        this.put(id, value);
    }

    public AttributesImpl(Attributes attributes) throws NamingException {
        if (attributes == null) {
            throw new NamingException("Cannot  create a copy of a null element");
        }
        if (attributes instanceof BasicAttributes) {
            NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
            this.keyMap = new HashMap<String, AttributeImpl>();
            while (attrs.hasMoreElements()) {
                AttributeImpl attribute = new AttributeImpl((Attribute)attrs.nextElement());
                this.put(attribute);
            }
        } else if (attributes instanceof AttributesImpl) {
            AttributesImpl clone = (AttributesImpl)attributes.clone();
            this.keyMap = new HashMap<String, AttributeImpl>(clone.keyMap.size());
            for (String key : clone.keyMap.keySet()) {
                AttributeImpl attribute = clone.keyMap.get(key);
                this.keyMap.put(key, (AttributeImpl)attribute.clone());
            }
        } else {
            throw new NamingException("Cannot create a copy of a object which is not an instance of AttributesImpl or of BasicAttributes");
        }
    }

    @Override
    public boolean isCaseIgnored() {
        return true;
    }

    @Override
    public int size() {
        return this.keyMap.size();
    }

    @Override
    public Attribute get(String attrId) {
        if (attrId != null) {
            String key = StringTools.lowerCaseAscii(attrId);
            return this.keyMap.get(key);
        }
        return null;
    }

    public NamingEnumeration<Attribute> getAll() {
        return new IteratorNamingEnumeration<Attribute>(new AttributeIterator(this));
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        String[] ids = new String[this.keyMap.size()];
        Iterator<AttributeImpl> values = this.keyMap.values().iterator();
        int i = 0;
        while (values.hasNext()) {
            ids[i++] = values.next().getID();
        }
        return new ArrayNamingEnumeration<String>(ids);
    }

    @Override
    public Attribute put(String attrId, Object val) {
        AttributeImpl attr = new AttributeImpl(attrId);
        attr.add(val);
        String key = StringTools.lowerCaseAscii(attrId);
        this.keyMap.put(key, attr);
        return attr;
    }

    @Override
    public Attribute put(Attribute attr) {
        String id = attr.getID();
        String key = StringTools.lowerCaseAscii(id);
        Attribute old = null;
        AttributeImpl newAttr = null;
        old = this.keyMap.containsKey(key) ? (Attribute)this.keyMap.remove(key) : attr;
        if (attr instanceof AttributeImpl) {
            newAttr = (AttributeImpl)attr;
        } else if (attr instanceof BasicAttribute) {
            newAttr = new AttributeImpl(id);
            try {
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMore()) {
                    newAttr.add(AttributeUtils.cloneValue(values.next()));
                }
            }
            catch (NamingException ne) {
                // empty catch block
            }
        }
        this.keyMap.put(key, newAttr);
        return old;
    }

    @Override
    public Attribute remove(String attrId) {
        String key = StringTools.lowerCaseAscii(attrId);
        if (this.keyMap.containsKey(key)) {
            return this.keyMap.remove(key);
        }
        return null;
    }

    @Override
    public Object clone() {
        try {
            AttributesImpl clone = (AttributesImpl)super.clone();
            clone.keyMap = new HashMap<String, AttributeImpl>(this.keyMap.size());
            for (String key : this.keyMap.keySet()) {
                clone.keyMap.put(key, (AttributeImpl)this.keyMap.get(key).clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Attribute attribute : this.keyMap.values()) {
            buf.append(attribute);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AttributesImpl)) {
            return false;
        }
        Attributes attrs = (Attributes)obj;
        if (attrs.size() != this.size()) {
            return false;
        }
        if (attrs.isCaseIgnored() != this.isCaseIgnored()) {
            return false;
        }
        NamingEnumeration<? extends Attribute> list = attrs.getAll();
        while (list.hasMoreElements()) {
            Attribute attr = (Attribute)list.nextElement();
            Attribute myAttr = this.get(attr.getID());
            if (myAttr == null) {
                return false;
            }
            if (myAttr.equals(attr)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeIterator<T>
    implements Iterator<Attribute> {
        private Iterator<AttributeImpl> iterator;

        private AttributeIterator(AttributesImpl attributes) {
            this.iterator = attributes.keyMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Attribute next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

