/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.Assertion;
import org.apache.directory.shared.ldap.filter.FilterVisitor;

public class AssertionNode
extends AbstractExprNode {
    private static final Long MAX = Long.MAX_VALUE;
    private final Assertion assertion;
    private final String desc;

    public AssertionNode(Assertion assertion) {
        this(assertion, "ASSERTION");
    }

    public AssertionNode(Assertion assertion, String desc) {
        this.desc = desc;
        this.assertion = assertion;
        this.set("count", MAX);
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public boolean isLeaf() {
        return true;
    }

    public StringBuilder printRefinementToBuffer(StringBuilder buf) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("AssertionNode can't be part of a refinement");
    }

    public Object accept(FilterVisitor visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(@");
        buf.append(this.desc);
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

