/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.Control;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.apache.directory.shared.ldap.ldif.LdifControl;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.name.LdapDnParser;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifReader
implements Iterator {
    private static final Logger log = LoggerFactory.getLogger(LdifReader.class);
    private List<String> lines;
    private Position position;
    private static final int DEFAULT_VERSION = 1;
    private int version;
    private static final int ENTRY = 0;
    private static final int CHANGE = 1;
    private static final int UNKNOWN = 2;
    private long sizeLimit = 1024000L;
    private static final long SIZE_LIMIT_DEFAULT = 1024000L;
    private static final int MOD_SPEC = 0;
    private static final int ATTRVAL_SPEC = 1;
    private static final int ATTRVAL_SPEC_OR_SEP = 2;
    private Entry prefetched;
    private Reader in;
    private boolean containsEntries;
    private boolean containsChanges;
    private Exception error;

    public LdifReader() {
        this.lines = new ArrayList<String>();
        this.position = new Position();
        this.version = 1;
    }

    private void init(BufferedReader inf) throws NamingException {
        this.in = inf;
        this.lines = new ArrayList<String>();
        this.position = new Position();
        this.version = 1;
        this.containsChanges = false;
        this.containsEntries = false;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
    }

    public LdifReader(String ldifFileName) throws NamingException {
        File inf = new File(ldifFileName);
        if (!inf.exists()) {
            log.error("File {} cannot be found", (Object)inf.getAbsoluteFile());
            throw new NamingException("Cannot find file " + inf.getAbsoluteFile());
        }
        if (!inf.canRead()) {
            log.error("File {} cannot be read", (Object)inf.getName());
            throw new NamingException("Cannot read file " + inf.getName());
        }
        try {
            this.init(new BufferedReader(new FileReader(inf)));
        }
        catch (FileNotFoundException fnfe) {
            log.error("File {} cannot be found", (Object)inf.getAbsoluteFile());
            throw new NamingException("Cannot find file " + inf.getAbsoluteFile());
        }
    }

    public LdifReader(BufferedReader in) throws NamingException {
        this.init(in);
    }

    public LdifReader(Reader in) throws NamingException {
        this.init(new BufferedReader(in));
    }

    public LdifReader(InputStream in) throws NamingException {
        this.init(new BufferedReader(new InputStreamReader(in)));
    }

    public LdifReader(File in) throws NamingException {
        if (!in.exists()) {
            log.error("File {} cannot be found", (Object)in.getAbsoluteFile());
            throw new NamingException("Cannot find file " + in.getAbsoluteFile());
        }
        if (!in.canRead()) {
            log.error("File {} cannot be read", (Object)in.getName());
            throw new NamingException("Cannot read file " + in.getName());
        }
        try {
            this.init(new BufferedReader(new FileReader(in)));
        }
        catch (FileNotFoundException fnfe) {
            log.error("File {} cannot be found", (Object)in.getAbsoluteFile());
            throw new NamingException("Cannot find file " + in.getAbsoluteFile());
        }
    }

    public int getVersion() {
        return this.version;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    private static void parseFill(char[] document, Position position) {
        while (StringTools.isCharASCII(document, position.pos, ' ')) {
            position.inc();
        }
    }

    private static String parseNumber(char[] document, Position position) {
        int initPos = position.pos;
        while (StringTools.isDigit(document, position.pos)) {
            position.inc();
        }
        if (position.pos == initPos) {
            return null;
        }
        return new String(document, initPos, position.pos - initPos);
    }

    private int parseChangeType(String line) {
        int operation = 0;
        String modOp = StringTools.trim(line.substring("changetype:".length() + 1));
        if ("add".equalsIgnoreCase(modOp)) {
            operation = 0;
        } else if ("delete".equalsIgnoreCase(modOp)) {
            operation = 4;
        } else if ("modify".equalsIgnoreCase(modOp)) {
            operation = 1;
        } else if ("moddn".equalsIgnoreCase(modOp)) {
            operation = 2;
        } else if ("modrdn".equalsIgnoreCase(modOp)) {
            operation = 3;
        }
        return operation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseDn(String line) throws NamingException {
        String dn = null;
        String lowerLine = line.toLowerCase();
        if (!lowerLine.startsWith("dn:") && !lowerLine.startsWith("DN:")) {
            log.error("A ldif entry must start with a DN");
            throw new NamingException("No DN for entry");
        }
        int length = line.length();
        if (length == 3) {
            log.error("A ldif entry must have a non empty DN");
            throw new NamingException("No DN for entry");
        }
        if (line.charAt(3) == ':') {
            if (length <= 4) {
                log.error("A ldif entry must have a non empty DN");
                throw new NamingException("No DN for entry");
            }
            String trimmedLine = line.substring(4).trim();
            try {
                dn = new String(Base64.decode(trimmedLine.toCharArray()), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                log.error("The ldif entry is supposed to have a base 64 encoded DN");
                throw new NamingException("Invalid base 64 encoded DN");
            }
        } else {
            dn = line.substring(3).trim();
        }
        try {
            LdapDnParser.parseInternal(dn, new ArrayList<Rdn>());
            return dn;
        }
        catch (InvalidNameException ine) {
            log.error("The DN {} is not valid");
            throw ine;
        }
    }

    private static Object parseSimpleValue(String line, int pos) {
        if (line.length() > pos + 1) {
            char c = line.charAt(pos + 1);
            if (c == ':') {
                String value = StringTools.trim(line.substring(pos + 2));
                return Base64.decode(value.toCharArray());
            }
            return StringTools.trim(line.substring(pos + 1));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parseValue(String line, int pos) throws NamingException {
        if (line.length() <= pos + 1) return null;
        char c = line.charAt(pos + 1);
        if (c == ':') {
            String value = StringTools.trim(line.substring(pos + 2));
            return Base64.decode(value.toCharArray());
        }
        if (c != '<') return StringTools.trim(line.substring(pos + 1));
        String urlName = StringTools.trim(line.substring(pos + 2));
        try {
            URL url = new URL(urlName);
            if (!"file".equals(url.getProtocol())) {
                log.error("Protocols other than file: are not supported");
                throw new NamingException("Unsupported URL protocol");
            }
            String fileName = url.getFile();
            File file = new File(fileName);
            if (!file.exists()) {
                log.error("File {} not found", (Object)fileName);
                throw new NamingException("Bad URL, file not found");
            }
            long length = file.length();
            if (length > this.sizeLimit) {
                log.error("File {} is too big", (Object)fileName);
                throw new NamingException("File too big");
            }
            byte[] data = new byte[(int)length];
            FilterInputStream inf = null;
            try {
                inf = new DataInputStream(new FileInputStream(file));
                ((DataInputStream)inf).read(data);
                byte[] byArray = data;
                return byArray;
            }
            catch (FileNotFoundException fnfe) {
                log.error("File {} not found", (Object)fileName);
                throw new NamingException("Bad URL, file not found");
            }
            catch (IOException ioe) {
                log.error("File {} error reading", (Object)fileName);
                throw new NamingException("Bad URL, file can't be read");
            }
            finally {
                if (inf != null) {
                    try {
                        inf.close();
                    }
                    catch (IOException ioe) {
                        log.error("Error while closing the stream : {}", (Object)ioe.getMessage());
                    }
                }
            }
        }
        catch (MalformedURLException mue) {
            log.error("Bad URL {}", (Object)urlName);
            throw new NamingException("Bad URL");
        }
    }

    private Control parseControl(String line) throws NamingException {
        String lowerLine = line.toLowerCase().trim();
        int pos = 0;
        char[] controlValue = line.trim().toCharArray();
        int length = controlValue.length;
        if (pos > length) {
            log.error("The control does not have an OID");
            throw new NamingException("Bad control, no oid");
        }
        int initPos = pos;
        while (StringTools.isCharASCII(controlValue, pos, '.') || StringTools.isDigit(controlValue, pos)) {
            ++pos;
        }
        if (pos == initPos) {
            log.error("The control does not have an OID");
            throw new NamingException("Bad control, no oid");
        }
        String oidString = lowerLine.substring(0, pos);
        OID oid = null;
        try {
            oid = new OID(oidString);
        }
        catch (DecoderException de) {
            log.error("The OID {} is not valid", (Object)oidString);
            throw new NamingException("Bad control oid");
        }
        LdifControl control = new LdifControl(oid);
        while (StringTools.isCharASCII(controlValue, pos, ' ')) {
            ++pos;
        }
        int criticalPos = lowerLine.indexOf(58);
        int criticalLength = 0;
        criticalLength = criticalPos == -1 ? length - pos : criticalPos - pos;
        if (criticalLength == 4 && "true".equalsIgnoreCase(lowerLine.substring(pos, pos + 4))) {
            control.setCriticality(true);
        } else if (criticalLength == 5 && "false".equalsIgnoreCase(lowerLine.substring(pos, pos + 5))) {
            control.setCriticality(false);
        } else if (criticalLength != 0) {
            log.error("The control muts have a valid criticality");
            throw new NamingException("Bad control criticality");
        }
        if (criticalPos > 0) {
            if (StringTools.isCharASCII(controlValue, criticalPos + 1, ':')) {
                byte[] value = Base64.decode(line.substring(criticalPos + 2).toCharArray());
                control.setValue(value);
            } else if (!StringTools.isCharASCII(controlValue, criticalPos + 1, '<')) {
                byte[] value = new byte[length - criticalPos - 1];
                for (int i = 0; i < length - criticalPos - 1; ++i) {
                    value[i] = (byte)controlValue[i + criticalPos + 1];
                }
                control.setValue(value);
            }
        }
        return control;
    }

    public static Attribute parseAttributeValue(String line) {
        int colonIndex = line.indexOf(58);
        if (colonIndex != -1) {
            String attributeType = line.toLowerCase().substring(0, colonIndex);
            Object attributeValue = LdifReader.parseSimpleValue(line, colonIndex);
            return new AttributeImpl(attributeType, attributeValue);
        }
        return null;
    }

    public void parseAttributeValue(Entry entry, String line, String lowerLine) throws NamingException {
        int colonIndex = line.indexOf(58);
        String attributeType = lowerLine.substring(0, colonIndex);
        if (attributeType.equals("dn")) {
            log.error("An entry must not have two DNs");
            throw new NamingException("A ldif entry should not have two DN");
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        entry.addAttribute(attributeType, attributeValue);
    }

    private void parseModRdn(Entry entry, Iterator iter) throws NamingException {
        String lowerLine;
        String line;
        if (iter.hasNext()) {
            line = (String)iter.next();
            lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("newrdn::") && !lowerLine.startsWith("newrdn:")) {
                log.error("A modrdn operation must start with a \"newrdn:\"");
                throw new NamingException("Bad modrdn operation");
            }
        } else {
            log.error("A modrdn operation must start with a \"newrdn:\"");
            throw new NamingException("Bad modrdn operation, no newrdn");
        }
        int colonIndex = line.indexOf(58);
        Object attributeValue = this.parseValue(line, colonIndex);
        entry.setNewRdn(attributeValue instanceof String ? (String)attributeValue : StringTools.utf8ToString((byte[])attributeValue));
        if (iter.hasNext()) {
            line = (String)iter.next();
            lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("deleteoldrdn:")) {
                log.error("A modrdn operation must contains a \"deleteoldrdn:\"");
                throw new NamingException("Bad modrdn operation, no deleteoldrdn");
            }
        } else {
            log.error("A modrdn operation must contains a \"deleteoldrdn:\"");
            throw new NamingException("Bad modrdn operation, no deleteoldrdn");
        }
        colonIndex = line.indexOf(58);
        attributeValue = this.parseValue(line, colonIndex);
        entry.setDeleteOldRdn("1".equals(attributeValue));
    }

    private void parseModify(Entry entry, Iterator iter) throws NamingException {
        int state = 0;
        String modified = null;
        int modification = 0;
        boolean isEmptyValue = true;
        while (iter.hasNext()) {
            String line = (String)iter.next();
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("-")) {
                if (state != 2) {
                    log.error("Bad state : we should have come from an ATTRVAL_SPEC");
                    throw new NamingException("Bad modify separator");
                }
                if (isEmptyValue) {
                    entry.addModificationItem(modification, modified, null);
                }
                state = 0;
                isEmptyValue = true;
                continue;
            }
            if (lowerLine.startsWith("add:")) {
                if (state != 0 && state != 1) {
                    log.error("Bad state : we should have come from a MOD_SPEC or an ATTRVAL_SPEC");
                    throw new NamingException("Bad modify state");
                }
                modified = StringTools.trim(line.substring("add:".length()));
                modification = 1;
                state = 1;
                continue;
            }
            if (lowerLine.startsWith("delete:")) {
                if (state != 0 && state != 1) {
                    log.error("Bad state : we should have come from a MOD_SPEC or an ATTRVAL_SPEC");
                    throw new NamingException("Bad modify state");
                }
                modified = StringTools.trim(line.substring("delete:".length()));
                modification = 3;
                state = 2;
                continue;
            }
            if (lowerLine.startsWith("replace:")) {
                if (state != 0 && state != 1) {
                    log.error("Bad state : we should have come from a MOD_SPEC or an ATTRVAL_SPEC");
                    throw new NamingException("Bad modify state");
                }
                modified = StringTools.trim(line.substring("replace:".length()));
                modification = 2;
                state = 2;
                continue;
            }
            if (state != 1 && state != 2) {
                log.error("Bad state : we should have come from an ATTRVAL_SPEC");
                throw new NamingException("Bad modify state");
            }
            int colonIndex = line.indexOf(58);
            String attributeType = lowerLine.substring(0, colonIndex);
            if (!attributeType.equals(modified)) {
                log.error("The modified attribute and the attribute value spec must be equal");
                throw new NamingException("Bad modify attribute");
            }
            if (attributeType.equals("dn")) {
                log.error("An entry must not have two DNs");
                throw new NamingException("A ldif entry should not have two DN");
            }
            Object attributeValue = this.parseValue(line, colonIndex);
            entry.addModificationItem(modification, attributeType, attributeValue);
            isEmptyValue = false;
            state = 2;
        }
    }

    private void parseChange(Entry entry, Iterator iter, int operation, Control control) throws NamingException {
        entry.setChangeType(operation);
        switch (operation) {
            case 4: {
                return;
            }
            case 0: {
                while (iter.hasNext()) {
                    String line = (String)iter.next();
                    String lowerLine = line.toLowerCase();
                    this.parseAttributeValue(entry, line, lowerLine);
                }
                return;
            }
            case 1: {
                this.parseModify(entry, iter);
                return;
            }
            case 2: 
            case 3: {
                this.parseModRdn(entry, iter);
                if (iter.hasNext()) {
                    String line = (String)iter.next();
                    String lowerLine = line.toLowerCase();
                    if (lowerLine.startsWith("newsuperior:")) {
                        int colonIndex = line.indexOf(58);
                        Object attributeValue = this.parseValue(line, colonIndex);
                        entry.setNewSuperior(attributeValue instanceof String ? (String)attributeValue : StringTools.utf8ToString((byte[])attributeValue));
                    } else if (operation == 2) {
                        log.error("A moddn operation must contains a \"newsuperior:\"");
                        throw new NamingException("Bad moddn operation, no newsuperior");
                    }
                } else if (operation == 2) {
                    log.error("A moddn operation must contains a \"newsuperior:\"");
                    throw new NamingException("Bad moddn operation, no newsuperior");
                }
                return;
            }
        }
        log.error("Unknown operation");
        throw new NamingException("Bad operation");
    }

    private Entry parseEntry() throws NamingException {
        if (this.lines == null || this.lines.size() == 0) {
            log.debug("The entry is empty : end of ldif file");
            return null;
        }
        String line = this.lines.get(0);
        String dn = this.parseDn(line);
        Entry entry = new Entry();
        entry.setDn(dn);
        this.lines.remove(0);
        Iterator<String> iter = this.lines.iterator();
        int type = 2;
        boolean controlSeen = false;
        boolean changeTypeSeen = false;
        int operation = 0;
        String lowerLine = null;
        Control control = null;
        while (iter.hasNext()) {
            line = iter.next();
            lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("control:")) {
                if (this.containsEntries) {
                    log.error("We cannot have changes when reading a file which already contains entries");
                    throw new NamingException("No changes withing entries");
                }
                this.containsChanges = true;
                if (controlSeen) {
                    log.error("We already have had a control");
                    throw new NamingException("Control misplaced");
                }
                control = this.parseControl(line.substring("control:".length()));
                entry.setControl(control);
                continue;
            }
            if (lowerLine.startsWith("changetype:")) {
                if (this.containsEntries) {
                    log.error("We cannot have changes when reading a file which already contains entries");
                    throw new NamingException("No changes withing entries");
                }
                this.containsChanges = true;
                if (changeTypeSeen) {
                    log.error("We already have had a changeType");
                    throw new NamingException("ChangeType misplaced");
                }
                type = 1;
                controlSeen = true;
                operation = this.parseChangeType(line);
                this.parseChange(entry, iter, operation, control);
                changeTypeSeen = true;
                continue;
            }
            if (line.indexOf(58) > 0) {
                if (this.containsChanges) {
                    log.error("We cannot have entries when reading a file which already contains changes");
                    throw new NamingException("No entries within changes");
                }
                this.containsEntries = true;
                if (controlSeen || changeTypeSeen) {
                    log.error("We can't have a Attribute/Value pair after a control or a changeType");
                    throw new NamingException("AttributeType misplaced");
                }
                this.parseAttributeValue(entry, line, lowerLine);
                type = 0;
                continue;
            }
            log.error("Expecting an attribute type");
            throw new NamingException("Bad attribute");
        }
        if (type == 0) {
            log.debug("Read an entry : {}", (Object)entry);
        } else if (type == 1) {
            entry.setChangeType(operation);
            log.debug("Read a modification : {}", (Object)entry);
        } else {
            log.error("Unknown entry type");
            throw new NamingException("Unknown entry");
        }
        return entry;
    }

    private int parseVersion() throws NamingException {
        int ver = 1;
        this.readLines();
        if (this.lines.size() == 0) {
            log.warn("The ldif file is empty");
            return ver;
        }
        String line = this.lines.get(0);
        char[] document = line.toCharArray();
        String versionNumber = null;
        if (line.startsWith("version:")) {
            this.position.inc("version:".length());
            LdifReader.parseFill(document, this.position);
            versionNumber = LdifReader.parseNumber(document, this.position);
            if (this.position.pos != document.length) {
                log.error("The version is not a number");
                throw new NamingException("Ldif parsing error");
            }
            try {
                ver = Integer.parseInt(versionNumber);
            }
            catch (NumberFormatException nfe) {
                log.error("The version is not a number");
                throw new NamingException("Ldif parsing error");
            }
            log.debug("Ldif version : {}", (Object)versionNumber);
            this.lines.remove(0);
            if (this.lines.size() == 0) {
                this.readLines();
            }
        } else {
            log.warn("No version information : assuming version: 1");
        }
        return ver;
    }

    private void readLines() throws NamingException {
        String line = null;
        boolean insideComment = true;
        boolean isFirstLine = true;
        this.lines.clear();
        StringBuffer sb = new StringBuffer();
        try {
            block6: while ((line = ((BufferedReader)this.in).readLine()) != null) {
                if (line.length() == 0) {
                    if (isFirstLine) continue;
                    insideComment = false;
                    break;
                }
                switch (line.charAt(0)) {
                    case '#': {
                        insideComment = true;
                        continue block6;
                    }
                    case ' ': {
                        isFirstLine = false;
                        if (insideComment) continue block6;
                        if (sb.length() == 0) {
                            log.error("Cannot have an empty continuation line");
                            throw new NamingException("Ldif Parsing error");
                        }
                        sb.append(line.substring(1));
                        insideComment = false;
                        continue block6;
                    }
                }
                isFirstLine = false;
                if (sb.length() != 0) {
                    this.lines.add(sb.toString());
                }
                sb = new StringBuffer(line);
                insideComment = false;
            }
        }
        catch (IOException ioe) {
            throw new NamingException("Error while reading ldif lines");
        }
        if (sb.length() != 0) {
            this.lines.add(sb.toString());
        }
    }

    public List parseLdifFile(String fileName) throws NamingException {
        return this.parseLdifFile(fileName, Charset.forName(StringTools.getDefaultCharsetName()).toString());
    }

    public List parseLdifFile(String fileName, String encoding) throws NamingException {
        BufferedReader inf;
        if (StringTools.isEmpty(fileName)) {
            log.error("Cannot parse an empty file name !");
            throw new NamingException("Empty filename");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            log.error("Cannot parse the file {}, it does not exist", (Object)fileName);
            throw new NamingException("Filename " + fileName + " not found.");
        }
        try {
            inf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName(encoding)));
        }
        catch (FileNotFoundException fnfe) {
            log.error("Cannot find file {}", (Object)fileName);
            throw new NamingException("Filename " + fileName + " not found.");
        }
        return this.parseLdif(inf);
    }

    public List parseLdif(String ldif) throws NamingException {
        log.debug("Starts parsing ldif buffer");
        if (StringTools.isEmpty(ldif)) {
            return new ArrayList();
        }
        StringReader strIn = new StringReader(ldif);
        BufferedReader inf = new BufferedReader(strIn);
        try {
            List<Entry> entries = this.parseLdif(inf);
            if (log.isDebugEnabled()) {
                log.debug("Parsed {} entries.", (Object)(entries == null ? Integer.valueOf(0) : Integer.valueOf(entries.size())));
            }
            return entries;
        }
        catch (NamingException ne) {
            log.error("Cannot parse the ldif buffer : {}", (Object)ne.getMessage());
            throw new NamingException("Error while parsing the ldif buffer");
        }
    }

    public Object next() throws NoSuchElementException {
        try {
            log.debug("next(): -- called");
            Entry entry = this.prefetched;
            this.readLines();
            try {
                this.prefetched = this.parseEntry();
            }
            catch (NamingException ne) {
                this.error = ne;
            }
            log.debug("next(): -- returning ldif {}\n", (Object)entry);
            return entry;
        }
        catch (NamingException ne) {
            log.error("Premature termination of LDIF iterator");
            this.error = ne;
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        log.debug("hasNext(): -- returning {}", (Object)(this.prefetched != null ? Boolean.TRUE : Boolean.FALSE));
        return null != this.prefetched;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public List<Entry> parseLdif(BufferedReader inf) throws NamingException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        this.in = inf;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
        while (this.hasNext()) {
            Entry entry = (Entry)this.next();
            if (this.error != null) {
                throw new NamingException("Error while parsing ldif : " + this.error.getMessage());
            }
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    public boolean containsEntries() {
        return this.containsEntries;
    }

    private class Position {
        public int pos = 0;

        public void inc() {
            ++this.pos;
        }

        public void inc(int val) {
            this.pos += val;
        }
    }
}

