/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.shared.ldap.filter.ExprNode;

public abstract class ProtectedItem
implements Serializable {
    public static final Entry ENTRY = new Entry();
    public static final AllUserAttributeTypes ALL_USER_ATTRIBUTE_TYPES = new AllUserAttributeTypes();
    public static final AllUserAttributeTypesAndValues ALL_USER_ATTRIBUTE_TYPES_AND_VALUES = new AllUserAttributeTypesAndValues();

    protected ProtectedItem() {
    }

    public abstract void printToBuffer(StringBuffer var1);

    public static class RestrictedByItem
    implements Serializable {
        private static final long serialVersionUID = 4319052153538757099L;
        private String attributeType;
        private String valuesIn;

        public RestrictedByItem(String attributeType, String valuesIn) {
            this.attributeType = attributeType;
            this.valuesIn = valuesIn;
        }

        public String getAttributeType() {
            return this.attributeType;
        }

        public String getValuesIn() {
            return this.valuesIn;
        }

        public String toString() {
            return "attributeType=" + this.attributeType + ", valuesIn=" + this.valuesIn;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append('{');
            buffer.append(' ');
            buffer.append("type");
            buffer.append(' ');
            buffer.append(this.attributeType);
            buffer.append(',');
            buffer.append(' ');
            buffer.append("valuesIn");
            buffer.append(' ');
            buffer.append(this.valuesIn);
            buffer.append(' ');
            buffer.append('}');
        }
    }

    public static class MaxValueCountItem
    implements Serializable {
        private static final long serialVersionUID = 43697038363452113L;
        private String attributeType;
        private int maxCount;

        public MaxValueCountItem(String attributeType, int maxCount) {
            this.attributeType = attributeType;
            this.maxCount = maxCount;
        }

        public String getAttributeType() {
            return this.attributeType;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public String toString() {
            return "attributeType=" + this.attributeType + ", maxCount=" + this.maxCount;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append('{');
            buffer.append(' ');
            buffer.append("type");
            buffer.append(' ');
            buffer.append(this.attributeType);
            buffer.append(',');
            buffer.append(' ');
            buffer.append("maxCount");
            buffer.append(' ');
            buffer.append(this.maxCount);
            buffer.append(' ');
            buffer.append('}');
        }
    }

    public static class RestrictedBy
    extends ProtectedItem {
        private static final long serialVersionUID = -8157637446588058799L;
        private final Collection items;

        public RestrictedBy(Collection items) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                if (RestrictedByItem.class.isAssignableFrom(i.next().getClass())) continue;
                throw new IllegalArgumentException("RestrictedBy items contains a wrong element.");
            }
            this.items = Collections.unmodifiableCollection(new ArrayList(items));
        }

        public Iterator iterator() {
            return this.items.iterator();
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (o instanceof RestrictedBy) {
                RestrictedBy that = (RestrictedBy)o;
                return ((Object)this.items).equals(that.items);
            }
            return false;
        }

        public String toString() {
            return "restrictedBy: " + this.items;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("restrictedBy");
            buffer.append(' ');
            buffer.append('{');
            buffer.append(' ');
            Iterator it = this.items.iterator();
            while (it.hasNext()) {
                RestrictedByItem item = (RestrictedByItem)it.next();
                item.printToBuffer(buffer);
                if (!it.hasNext()) continue;
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(' ');
            buffer.append('}');
        }
    }

    public static class MaxImmSub
    extends ProtectedItem {
        private static final long serialVersionUID = -8553151906617285325L;
        private final int value;

        public MaxImmSub(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MaxImmSub) {
                MaxImmSub that = (MaxImmSub)o;
                return this.value == that.value;
            }
            return false;
        }

        public String toString() {
            return "maxImmSub: " + this.value;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("maxImmSub");
            buffer.append(' ');
            buffer.append(this.value);
        }
    }

    public static class RangeOfValues
    extends ProtectedItem {
        private static final long serialVersionUID = -8553151906617285325L;
        private final ExprNode filter;

        public RangeOfValues(ExprNode filter) {
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            this.filter = filter;
        }

        public ExprNode getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof RangeOfValues) {
                RangeOfValues that = (RangeOfValues)o;
                return this.filter.equals(that.filter);
            }
            return false;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("rangeOfValues: ");
            this.filter.printToBuffer(buf);
            return buf.toString();
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("rangeOfValues");
            buffer.append(' ');
            this.filter.printToBuffer(buffer);
        }
    }

    public static class MaxValueCount
    extends ProtectedItem {
        private static final long serialVersionUID = 5261651541488944572L;
        private final Collection items;

        public MaxValueCount(Collection items) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                if (MaxValueCountItem.class.isAssignableFrom(i.next().getClass())) continue;
                throw new IllegalArgumentException("Max value count contains a wrong element.");
            }
            this.items = Collections.unmodifiableCollection(new ArrayList(items));
        }

        public Iterator iterator() {
            return this.items.iterator();
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (o instanceof MaxValueCount) {
                MaxValueCount that = (MaxValueCount)o;
                return ((Object)this.items).equals(that.items);
            }
            return false;
        }

        public String toString() {
            return "maxValueCount: " + this.items;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("maxValueCount");
            buffer.append(' ');
            buffer.append('{');
            buffer.append(' ');
            Iterator it = this.items.iterator();
            while (it.hasNext()) {
                MaxValueCountItem item = (MaxValueCountItem)it.next();
                item.printToBuffer(buffer);
                if (!it.hasNext()) continue;
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(' ');
            buffer.append('}');
        }
    }

    public static class AttributeValue
    extends ProtectedItem {
        private static final long serialVersionUID = -258318397837951363L;
        private final Collection attributes;

        public AttributeValue(Collection attributes) {
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                if (Attribute.class.isAssignableFrom(i.next().getClass())) continue;
                throw new IllegalArgumentException("attributeTypes contains an element which is not an attribute.");
            }
            this.attributes = Collections.unmodifiableCollection(new ArrayList(attributes));
        }

        public Iterator iterator() {
            return this.attributes.iterator();
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (o instanceof AttributeValue) {
                AttributeValue that = (AttributeValue)o;
                return ((Object)this.attributes).equals(that.attributes);
            }
            return false;
        }

        public String toString() {
            return "attributeValue: " + this.attributes;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("attributeValue");
            buffer.append(' ');
            buffer.append('{');
            buffer.append(' ');
            Iterator it = this.attributes.iterator();
            while (it.hasNext()) {
                Attribute attribute = (Attribute)it.next();
                buffer.append(attribute.getID());
                buffer.append('=');
                try {
                    buffer.append(attribute.get(0));
                }
                catch (NamingException e) {
                    // empty catch block
                }
                if (!it.hasNext()) continue;
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(' ');
            buffer.append('}');
        }
    }

    public static class SelfValue
    extends AttributeTypeProtectedItem {
        private static final long serialVersionUID = -7788463918070206609L;

        public SelfValue(Collection attributeTypes) {
            super(attributeTypes);
        }

        public String toString() {
            return "selfValue: " + this.attributeTypes;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("selfValue");
            buffer.append(' ');
            super.printToBuffer(buffer);
        }
    }

    public static class AllAttributeValues
    extends AttributeTypeProtectedItem {
        private static final long serialVersionUID = -9039274739078220203L;

        public AllAttributeValues(Collection attributeTypes) {
            super(attributeTypes);
        }

        public String toString() {
            return "allAttributeValues: " + this.attributeTypes;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("allAttributeValues");
            buffer.append(' ');
            super.printToBuffer(buffer);
        }
    }

    public static class AttributeType
    extends AttributeTypeProtectedItem {
        private static final long serialVersionUID = -9039274739078220203L;

        public AttributeType(Collection attributeTypes) {
            super(attributeTypes);
        }

        public String toString() {
            return "attributeType: " + this.attributeTypes;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("attributeType");
            buffer.append(' ');
            super.printToBuffer(buffer);
        }
    }

    private static abstract class AttributeTypeProtectedItem
    extends ProtectedItem {
        protected final Collection attributeTypes;

        protected AttributeTypeProtectedItem(Collection attributeTypes) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (Object val : attributeTypes) {
                if (!String.class.isAssignableFrom(val.getClass())) {
                    throw new IllegalArgumentException("attributeTypes contains an element which is not a string.");
                }
                tmp.add(((String)val).toLowerCase());
            }
            this.attributeTypes = Collections.unmodifiableCollection(tmp);
        }

        public Iterator iterator() {
            return this.attributeTypes.iterator();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass().isAssignableFrom(o.getClass())) {
                AttributeTypeProtectedItem that = (AttributeTypeProtectedItem)o;
                return ((Object)this.attributeTypes).equals(that.attributeTypes);
            }
            return false;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append('{');
            buffer.append(' ');
            Iterator it = this.attributeTypes.iterator();
            while (it.hasNext()) {
                String attributeType = (String)it.next();
                buffer.append(attributeType);
                if (!it.hasNext()) continue;
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(' ');
            buffer.append('}');
        }
    }

    public static class AllUserAttributeTypesAndValues
    extends ProtectedItem {
        private static final long serialVersionUID = 7250988885983604442L;

        private AllUserAttributeTypesAndValues() {
        }

        public String toString() {
            return "allUserAttributeTypesAndValues";
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("allUserAttributeTypesAndValues");
        }
    }

    public static class AllUserAttributeTypes
    extends ProtectedItem {
        private static final long serialVersionUID = 3728652941148931359L;

        private AllUserAttributeTypes() {
        }

        public String toString() {
            return "allUserAttributeTypes";
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("allUserAttributeTypes");
        }
    }

    public static class Entry
    extends ProtectedItem {
        private static final long serialVersionUID = -6971482229815999874L;

        private Entry() {
        }

        public String toString() {
            return "entry";
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("entry");
        }
    }

    public static class Classes
    extends ProtectedItem {
        private static final long serialVersionUID = -8553151906617285325L;
        private final ExprNode classes;

        public Classes(ExprNode classes) {
            this.classes = classes;
        }

        public ExprNode getClasses() {
            return this.classes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Classes) {
                Classes that = (Classes)o;
                return this.classes.equals(that.classes);
            }
            return false;
        }

        public void printToBuffer(StringBuffer buffer) {
            buffer.append("classes");
            buffer.append(' ');
            this.classes.printRefinementToBuffer(buffer);
        }
    }
}

