/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import java.util.Collections;
import java.util.Set;
import javax.naming.Name;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.LdapName;
import org.apache.directory.shared.ldap.subtree.BaseSubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

public class SubtreeSpecificationModifier {
    private Name base = new LdapName();
    private Set chopBefore = Collections.EMPTY_SET;
    private Set chopAfter = Collections.EMPTY_SET;
    private int minBaseDistance = 0;
    private int maxBaseDistance = -1;
    private ExprNode refinement = null;

    public SubtreeSpecification getSubtreeSpecification() {
        return new BaseSubtreeSpecification(this.base, this.minBaseDistance, this.maxBaseDistance, this.chopAfter, this.chopBefore, this.refinement);
    }

    public void setBase(Name base) {
        this.base = base;
    }

    public void setChopBeforeExclusions(Set chopBefore) {
        this.chopBefore = chopBefore;
    }

    public void setChopAfterExclusions(Set chopAfter) {
        this.chopAfter = chopAfter;
    }

    public void setMinBaseDistance(int minBaseDistance) {
        if (minBaseDistance < 0) {
            throw new IllegalArgumentException("A negative minimum base distance is undefined!");
        }
        this.minBaseDistance = minBaseDistance;
    }

    public void setMaxBaseDistance(int maxBaseDistance) {
        this.maxBaseDistance = maxBaseDistance < 0 ? -1 : maxBaseDistance;
    }

    public void setRefinement(ExprNode refinement) {
        this.refinement = refinement;
    }
}

