/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.compare;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.compare.CompareResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)CompareResponseGrammar.class);
    private static IGrammar instance = new CompareResponseGrammar();

    private CompareResponseGrammar() {
        this.name = CompareResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_COMPARE_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.COMPARE_RESPONSE_TAG][111] = new GrammarTransition(LdapStatesEnum.COMPARE_RESPONSE_TAG, LdapStatesEnum.COMPARE_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_RESPONSE_VALUE][111] = new GrammarTransition(LdapStatesEnum.COMPARE_RESPONSE_VALUE, LdapStatesEnum.COMPARE_RESPONSE_LDAP_RESULT, new GrammarAction("Init CompareResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    String msg = "The CompareResponse must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                ldapMessage.setProtocolOP(new CompareResponse());
                log.debug("Compare response ");
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.COMPARE_RESPONSE_LDAP_RESULT, 512, new GrammarAction("Pop allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

