/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.util.StringTools;

public class ExtensibleMatchFilter
extends Filter {
    private transient int expectedMatchingRuleLength;
    private String matchingRule;
    private transient byte[] matchingRuleBytes;
    private String type;
    private transient byte[] typeBytes;
    private Object matchValue;
    private boolean dnAttributes = false;
    private transient int extensibleMatchLength;

    public boolean isDnAttributes() {
        return this.dnAttributes;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.dnAttributes = dnAttributes;
    }

    public String getMatchingRule() {
        return this.matchingRule;
    }

    public void setMatchingRule(String matchingRule) {
        this.matchingRule = matchingRule;
    }

    public Object getMatchValue() {
        return this.matchValue;
    }

    public void setMatchValue(Object matchValue) {
        this.matchValue = matchValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getExpectedMatchingRuleLength() {
        return this.expectedMatchingRuleLength;
    }

    public void setExpectedMatchingRuleLength(int expectedMatchingRuleLength) {
        this.expectedMatchingRuleLength = expectedMatchingRuleLength;
    }

    public int computeLength() {
        if (this.matchingRule != null) {
            this.matchingRuleBytes = StringTools.getBytesUtf8(this.matchingRule);
            this.extensibleMatchLength = 1 + TLV.getNbBytes((int)this.matchingRuleBytes.length) + this.matchingRuleBytes.length;
        }
        if (this.type != null) {
            this.typeBytes = StringTools.getBytesUtf8(this.type);
            this.extensibleMatchLength += 1 + TLV.getNbBytes((int)this.typeBytes.length) + this.typeBytes.length;
        }
        if (this.matchValue != null) {
            if (this.matchValue instanceof String) {
                int matchValueLength = StringTools.getBytesUtf8((String)this.matchValue).length;
                this.extensibleMatchLength += 1 + TLV.getNbBytes((int)matchValueLength) + matchValueLength;
            } else {
                this.extensibleMatchLength += 1 + TLV.getNbBytes((int)((byte[])this.matchValue).length) + ((byte[])this.matchValue).length;
            }
        }
        if (this.dnAttributes) {
            this.extensibleMatchLength += 3;
        }
        return 1 + TLV.getNbBytes((int)this.extensibleMatchLength) + this.extensibleMatchLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-87);
            buffer.put(TLV.getBytes((int)this.extensibleMatchLength));
            if (this.matchingRule == null && this.type == null) {
                throw new EncoderException("Cannot have a null matching rule and a null type");
            }
            if (this.matchingRule != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes((int)this.matchingRuleBytes.length));
                buffer.put(this.matchingRuleBytes);
            }
            if (this.type != null) {
                buffer.put((byte)-126);
                buffer.put(TLV.getBytes((int)this.typeBytes.length));
                buffer.put(this.typeBytes);
            }
            if (this.matchValue != null) {
                buffer.put((byte)-125);
                if (this.matchValue instanceof String) {
                    byte[] matchValueBytes = StringTools.getBytesUtf8((String)this.matchValue);
                    buffer.put(TLV.getBytes((int)matchValueBytes.length));
                    if (matchValueBytes.length != 0) {
                        buffer.put(matchValueBytes);
                    }
                } else {
                    buffer.put(TLV.getBytes((int)((byte[])this.matchValue).length));
                    if (((byte[])this.matchValue).length != 0) {
                        buffer.put((byte[])this.matchValue);
                    }
                }
            }
            if (this.dnAttributes) {
                buffer.put((byte)-124);
                buffer.put((byte)1);
                buffer.put((byte)-1);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.type != null) {
            sb.append(this.type.toString());
        }
        if (this.dnAttributes) {
            sb.append(":dn");
        }
        if (this.matchingRule == null) {
            if (this.type == null) {
                return "Extended Filter wrong syntax";
            }
        } else {
            sb.append(':').append(this.matchingRule.toString());
        }
        sb.append(":=").append(this.matchValue.toString());
        return sb.toString();
    }
}

