/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.compare;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class CompareRequest
extends LdapMessage {
    private LdapDN entry;
    private LdapString attributeDesc;
    private Object assertionValue;
    private transient int compareRequestLength;
    private transient int avaLength;

    public int getMessageType() {
        return 5;
    }

    public LdapDN getEntry() {
        return this.entry;
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public Object getAssertionValue() {
        return this.assertionValue;
    }

    public void setAssertionValue(Object assertionValue) {
        this.assertionValue = assertionValue;
    }

    public String getAttributeDesc() {
        return this.attributeDesc == null ? "" : this.attributeDesc.getString();
    }

    public void setAttributeDesc(LdapString attributeDesc) {
        this.attributeDesc = attributeDesc;
    }

    public int computeLength() {
        this.compareRequestLength = 1 + Length.getNbBytes((int)LdapDN.getNbBytes(this.entry)) + LdapDN.getNbBytes(this.entry);
        this.avaLength = 1 + Length.getNbBytes((int)this.attributeDesc.getNbBytes()) + this.attributeDesc.getNbBytes();
        if (this.assertionValue instanceof String) {
            int assertionValueLength = StringTools.getBytesUtf8((String)this.assertionValue).length;
            this.avaLength += 1 + Length.getNbBytes((int)assertionValueLength) + assertionValueLength;
        } else {
            this.avaLength += 1 + Length.getNbBytes((int)((byte[])this.assertionValue).length) + ((byte[])this.assertionValue).length;
        }
        this.compareRequestLength += 1 + Length.getNbBytes((int)this.avaLength) + this.avaLength;
        return 1 + Length.getNbBytes((int)this.compareRequestLength) + this.compareRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)110);
            buffer.put(Length.getBytes((int)this.compareRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.entry));
            buffer.put((byte)48);
            buffer.put(Length.getBytes((int)this.avaLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (String)this.attributeDesc.getString());
        if (this.assertionValue instanceof String) {
            Value.encode((ByteBuffer)buffer, (String)((String)this.assertionValue));
        } else {
            Value.encode((ByteBuffer)buffer, (byte[])((byte[])this.assertionValue));
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Compare request\n");
        sb.append("        Entry : '").append(this.entry.toString()).append("'\n");
        sb.append("        Attribute description : '").append(this.attributeDesc.toString()).append("'\n");
        sb.append("        Attribute value : '").append(this.assertionValue.toString()).append("'\n");
        return sb.toString();
    }
}

