/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.name.RdnParser;
import org.apache.directory.shared.ldap.util.StringTools;

public class LdapDnParser
implements NameParser {
    private static LdapDnParser instance = new LdapDnParser();

    private LdapDnParser() {
    }

    public static NameParser getNameParser() {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseInternal(String dn, List rdns) throws InvalidNameException {
        char[] chars = dn.trim().toCharArray();
        if (chars.length == 0) {
            return;
        }
        int pos = 0;
        Rdn rdn = new Rdn();
        if ((pos = RdnParser.parse(chars, pos, rdn)) == -1) throw new InvalidNameException("Bad DN : " + new String(chars));
        do {
            rdns.add(rdn.clone());
            rdn.clear();
            if (!StringTools.isCharASCII(chars, pos, ',') && !StringTools.isCharASCII(chars, pos, ';')) return;
            chars[pos] = 44;
            ++pos;
        } while ((pos = RdnParser.parse(chars, pos, rdn)) != -1);
    }

    public Name parse(String dn) throws InvalidNameException {
        return new LdapDN(dn);
    }
}

