/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class NoticeOfDisconnect
extends ExtendedResponseImpl {
    private static final long serialVersionUID = -4682291068700593492L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    private static final byte[] EMPTY_RESPONSE = new byte[0];
    public static NoticeOfDisconnect UNAVAILABLE = new NoticeOfDisconnect(ResultCodeEnum.UNAVAILABLE);
    public static NoticeOfDisconnect PROTOCOLERROR = new NoticeOfDisconnect(ResultCodeEnum.PROTOCOLERROR);
    public static NoticeOfDisconnect STRONGAUTHREQUIRED = new NoticeOfDisconnect(ResultCodeEnum.STRONGAUTHREQUIRED);

    private NoticeOfDisconnect(ResultCodeEnum rcode) {
        super(0);
        switch (rcode.getValue()) {
            case 52: {
                break;
            }
            case 2: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The result code can only be one of: " + ResultCodeEnum.UNAVAILABLE + ", " + ResultCodeEnum.PROTOCOLERROR + ", " + ResultCodeEnum.STRONGAUTHREQUIRED);
            }
        }
        super.getLdapResult().setErrorMessage("The server will disconnect!");
        super.getLdapResult().setMatchedDn("");
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return EMPTY_RESPONSE;
    }

    public void setResponse(byte[] value) {
        throw new UnsupportedOperationException("the response is hardcoded as zero length array");
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException("the OID is fixed: 1.3.6.1.4.1.1466.20036");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof NoticeOfDisconnect;
    }
}

