/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.message.ArrayNamingEnumeration;
import org.apache.directory.shared.ldap.message.IteratorNamingEnumeration;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.util.ExceptionUtils;

public class LockableAttributesImpl
implements Attributes {
    static final long serialVersionUID = -69864533495992471L;
    private final Map map = new HashMap();
    private Map keyMap = new HashMap();

    public LockableAttributesImpl() {
    }

    private LockableAttributesImpl(Map map, Map keyMap) {
        if (keyMap != null) {
            this.keyMap.putAll(keyMap);
        }
        Iterator list = map.values().iterator();
        while (list.hasNext()) {
            Attribute attr = (Attribute)list.next();
            this.map.put(attr.getID(), attr.clone());
        }
    }

    public boolean isCaseIgnored() {
        return true;
    }

    public int size() {
        return this.map.size();
    }

    public Attribute get(String attrId) {
        String key = this.getUserProvidedId(attrId);
        if (key == null) {
            return null;
        }
        return (Attribute)this.map.get(key);
    }

    public NamingEnumeration getAll() {
        return new IteratorNamingEnumeration(this.map.values().iterator());
    }

    public NamingEnumeration getIDs() {
        return new ArrayNamingEnumeration(this.map.keySet().toArray());
    }

    public Attribute put(String attrId, Object val) {
        if (this.get(attrId) == null) {
            this.setUserProvidedId(attrId);
        }
        LockableAttributeImpl attr = new LockableAttributeImpl(attrId);
        attr.add(val);
        this.map.put(attrId, attr);
        return attr;
    }

    public Attribute put(Attribute attr) {
        Attribute old = this.get(attr.getID());
        if (old != null) {
            this.map.remove(old.getID());
            if (this.keyMap != null) {
                this.keyMap.remove(old.getID().toLowerCase());
            }
        }
        this.map.put(attr.getID(), attr);
        this.setUserProvidedId(attr.getID());
        return old;
    }

    public Attribute remove(String attrId) {
        Attribute old = this.get(attrId);
        if (old != null) {
            this.map.remove(old.getID());
            if (this.keyMap != null) {
                this.keyMap.remove(old.getID().toLowerCase());
            }
        }
        return old;
    }

    public Object clone() {
        return new LockableAttributesImpl(this.map, this.keyMap);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator attrs = this.map.values().iterator();
        while (attrs.hasNext()) {
            Attribute l_attr = (Attribute)attrs.next();
            try {
                NamingEnumeration<?> l_values = l_attr.getAll();
                while (l_values.hasMore()) {
                    Object l_value = l_values.next();
                    buf.append(l_attr.getID());
                    buf.append(": ");
                    buf.append(l_value);
                    buf.append('\n');
                }
            }
            catch (NamingException e) {
                buf.append(ExceptionUtils.getFullStackTrace(e));
            }
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attributes)) {
            return false;
        }
        Attributes attrs = (Attributes)obj;
        if (attrs.size() != this.size()) {
            return false;
        }
        if (attrs.isCaseIgnored() != this.isCaseIgnored()) {
            return false;
        }
        NamingEnumeration<? extends Attribute> list = attrs.getAll();
        while (list.hasMoreElements()) {
            Attribute attr = (Attribute)list.nextElement();
            Attribute myAttr = this.get(attr.getID());
            if (myAttr == null) {
                return false;
            }
            if (myAttr.equals(attr)) continue;
            return false;
        }
        return true;
    }

    private void setUserProvidedId(String userProvidedId) {
        if (this.keyMap == null) {
            this.keyMap = new HashMap();
            this.keyMap.put(userProvidedId.toLowerCase(), userProvidedId);
            return;
        }
        if (this.keyMap.get(userProvidedId) == null) {
            this.keyMap.put(userProvidedId.toLowerCase(), userProvidedId);
        }
    }

    private String getUserProvidedId(String attrId) {
        if (this.map.containsKey(attrId)) {
            return attrId;
        }
        if (this.keyMap == null) {
            this.keyMap = new HashMap();
            return null;
        }
        return (String)this.keyMap.get(attrId.toLowerCase());
    }
}

