/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.message.ControlImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryChangeControl
extends ControlImpl {
    private static final long serialVersionUID = -2356861450876343999L;
    private static final Logger log = LoggerFactory.getLogger((Class)EntryChangeControl.class);
    public static final String CONTROL_OID = "2.16.840.1.113730.3.4.7";
    public static final int UNDEFINED_CHANGE_NUMBER = -1;
    private ChangeType changeType = ChangeType.ADD;
    private int changeNumber = -1;
    private LdapString previousDn = null;

    public EntryChangeControl() {
        this.setType(CONTROL_OID);
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public String getPreviousDn() {
        return this.previousDn.getString();
    }

    public void setPreviousDn(String previousDn) {
        try {
            this.previousDn = new LdapString(Asn1StringUtils.getBytesUtf8((String)previousDn));
        }
        catch (LdapStringEncodingException e) {
            e.printStackTrace();
        }
    }

    public void setPreviousDn(LdapString previousDn) {
        this.previousDn = previousDn;
    }

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public void setChangeNumber(int changeNumber) {
        this.changeNumber = changeNumber;
    }

    public byte[] getEncodedValue() {
        if (this.getValue() == null) {
            org.apache.directory.shared.ldap.codec.search.controls.EntryChangeControl ecc = new org.apache.directory.shared.ldap.codec.search.controls.EntryChangeControl();
            ecc.setChangeNumber(this.changeNumber);
            ecc.setChangeType(this.changeType);
            ecc.setPreviousDn(this.previousDn);
            try {
                this.setValue(ecc.encode(null).array());
            }
            catch (EncoderException e) {
                log.error("Failed to encode psearch control", (Throwable)e);
            }
        }
        return this.getValue();
    }
}

