/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchingRuleAssertionGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)MatchingRuleAssertionGrammar.class);
    private static IGrammar instance = new MatchingRuleAssertionGrammar();

    private MatchingRuleAssertionGrammar() {
        this.name = MatchingRuleAssertionGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_FILTER_STATE][256];
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_TAG][169] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_TAG, LdapStatesEnum.MATCHING_RULE_ASSERTION_VALUE, null);
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_VALUE][169] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_VALUE, LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCHING_RULE_OR_TYPE_TAG, new GrammarAction("Init extensible match Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                ExtensibleMatchFilter extensibleMatchFilter = new ExtensibleMatchFilter();
                Filter currentFilter = searchRequest.getCurrentFilter();
                if (currentFilter != null) {
                    ((ConnectorFilter)currentFilter).addFilter(extensibleMatchFilter);
                    extensibleMatchFilter.setParent(currentFilter);
                } else {
                    searchRequest.setFilter(extensibleMatchFilter);
                    extensibleMatchFilter.setParent(searchRequest);
                }
                searchRequest.setCurrentFilter(extensibleMatchFilter);
                MatchingRuleAssertionGrammar.this.unstackFilters(container);
            }
        });
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCHING_RULE_OR_TYPE_TAG][129] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCHING_RULE_OR_TYPE_TAG, LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCHING_RULE_VALUE, null);
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCHING_RULE_VALUE][129] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCHING_RULE_VALUE, LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_OR_MATCH_VALUE_TAG, new GrammarAction("Store matching rule Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getCurrentFilter();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The matching rule is empty");
                    throw new DecoderException("Invalid matching rule : it can't be empty");
                }
                try {
                    extensibleMatchFilter.setMatchingRule(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    String msg = StringTools.dumpBytes(tlv.getValue().getData());
                    log.error("The matching rule ({}) is invalid", (Object)msg);
                    throw new DecoderException("Invalid matching rule " + msg + ", : " + lsee.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCHING_RULE_OR_TYPE_TAG][130] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCHING_RULE_OR_TYPE_TAG, LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_OR_MATCH_VALUE_TAG][130] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_OR_MATCH_VALUE_TAG, LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_VALUE][130] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_VALUE, LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCH_VALUE_TAG, new GrammarAction("Store matching type Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The type cannot be null in a MacthingRuleAssertion");
                    throw new DecoderException("The type cannot be null in a MacthingRuleAssertion");
                }
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getCurrentFilter();
                try {
                    LdapString type = LdapDN.normalizeAttribute(tlv.getValue().getData());
                    extensibleMatchFilter.setType(type);
                }
                catch (LdapStringEncodingException lsee) {
                    String msg = StringTools.dumpBytes(tlv.getValue().getData());
                    log.error("The match filter ({}) is invalid", (Object)msg);
                    throw new DecoderException("Invalid match filter " + msg + ", : " + lsee.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_OR_MATCH_VALUE_TAG][131] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_TYPE_OR_MATCH_VALUE_TAG, LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCH_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCH_VALUE_TAG][131] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCH_VALUE_TAG, LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCH_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCH_VALUE_VALUE][131] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_MATCH_VALUE_VALUE, LdapStatesEnum.MATCHING_RULE_ASSERTION_DN_ATTRIBUTES_TAG, new GrammarAction("Store matching match value Value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getCurrentFilter();
                extensibleMatchFilter.setMatchValue(StringTools.utf8ToString(tlv.getValue().getData()));
                ldapMessageContainer.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_DN_ATTRIBUTES_TAG][132] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_DN_ATTRIBUTES_TAG, LdapStatesEnum.MATCHING_RULE_ASSERTION_DN_ATTRIBUTES_VALUE, null);
        this.transitions[LdapStatesEnum.MATCHING_RULE_ASSERTION_DN_ATTRIBUTES_VALUE][132] = new GrammarTransition(LdapStatesEnum.MATCHING_RULE_ASSERTION_DN_ATTRIBUTES_VALUE, -1, new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getCurrentFilter();
                Value value = tlv.getValue();
                try {
                    extensibleMatchFilter.setDnAttributes(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The DN attributes flag {} is invalid : {}. It should be 0 or 255", (Object)StringTools.dumpBytes(value.getData()), (Object)bde.getMessage());
                    throw new DecoderException(bde.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("DN Attributes : {}", (Object)new Boolean(extensibleMatchFilter.isDnAttributes()));
                }
                ldapMessageContainer.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }

    private void unstackFilters(IAsn1Container container) {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        Filter currentFilter = searchRequest.getCurrentFilter();
        if (tlv.getParent().getExpectedLength() == 0) {
            TLV parent = tlv.getParent();
            while (parent != null && parent.getExpectedLength() == 0) {
                parent = parent.getParent();
                if (currentFilter != null && currentFilter.getParent() instanceof Filter) {
                    currentFilter = (Filter)currentFilter.getParent();
                    continue;
                }
                currentFilter = null;
                break;
            }
            searchRequest.setCurrentFilter(currentFilter);
        }
    }
}

