/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulAction;

public class GracefulShutdown
extends GracefulAction {
    private transient int gracefulSequenceLength;

    public int computeLength() {
        int gracefulLength = 2;
        this.gracefulSequenceLength = 0;
        if (this.timeOffline != 0) {
            this.gracefulSequenceLength += 2 + Value.getNbBytes((int)this.timeOffline);
        }
        if (this.delay != 0) {
            this.gracefulSequenceLength += 2 + Value.getNbBytes((int)this.delay);
        }
        return gracefulLength + this.gracefulSequenceLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(Length.getBytes((int)this.gracefulSequenceLength));
        if (this.timeOffline != 0) {
            Value.encode((ByteBuffer)bb, (int)this.timeOffline);
        }
        if (this.delay != 0) {
            bb.put((byte)-128);
            bb.put((byte)Value.getNbBytes((int)this.delay));
            bb.put(Value.getBytes((int)this.delay));
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Graceful Shiutdown extended operation");
        sb.append("    TimeOffline : ").append(this.timeOffline).append('\n');
        sb.append("    Delay : ").append(this.delay).append('\n');
        return sb.toString();
    }
}

