/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.add;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.add.AddRequest;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)AddRequestGrammar.class);
    private static IGrammar instance = new AddRequestGrammar();

    private AddRequestGrammar() {
        this.name = AddRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_ADD_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.ADD_REQUEST_TAG][104] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_TAG, LdapStatesEnum.ADD_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_VALUE][104] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_VALUE, LdapStatesEnum.ADD_REQUEST_ENTRY_TAG, new GrammarAction("Init addRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    String msg = "The AddRequest must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                ldapMessage.setProtocolOP(new AddRequest());
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_ENTRY_TAG][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ENTRY_TAG, LdapStatesEnum.ADD_REQUEST_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ENTRY_VALUE][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ENTRY_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_LIST_TAG, new GrammarAction("Store add request object Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddRequest addRequest = ldapMessage.getAddRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The DN can't be null");
                }
                Name entry = null;
                try {
                    entry = new LdapDN(tlv.getValue().getData());
                    entry = LdapDN.normalize(entry);
                }
                catch (InvalidNameException ine) {
                    String msg = "The DN is invalid : " + StringTools.dumpBytes(tlv.getValue().getData()) + " : " + ine.getMessage();
                    log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    throw new DecoderException(msg, (Throwable)ine);
                }
                catch (NamingException ne) {
                    String msg = "The DN is invalid : " + StringTools.dumpBytes(tlv.getValue().getData()) + " : " + ne.getMessage();
                    log.error("{} : {}", (Object)msg, (Object)ne.getMessage());
                    throw new DecoderException(msg, (Throwable)ne);
                }
                addRequest.setEntry(entry);
                log.debug("Adding an entry with DN : {}", (Object)addRequest.getEntry());
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_LIST_TAG][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_LIST_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_LIST_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_LIST_VALUE][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_LIST_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TAG, new GrammarAction("Init attributes array list"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddRequest addRequest = ldapMessage.getAddRequest();
                addRequest.initAttributes();
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TAG][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_OR_ATTRIBUTE_OR_END][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_OR_ATTRIBUTE_OR_END, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALUE][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TYPE_TAG, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TYPE_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TYPE_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALS_TAG, new GrammarAction("Store attribute type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                AddRequest addRequest = ldapMessage.getAddRequest();
                LdapString type = null;
                if (tlv.getLength().getLength() == 0) {
                    log.error("Null types are not allowed");
                    throw new DecoderException("The type can't be null");
                }
                try {
                    type = LdapDN.normalizeAttribute(tlv.getValue().getData());
                    addRequest.addAttributeType(type);
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The type is invalid : {} : {}", (Object)StringTools.dumpBytes(tlv.getValue().getData()), (Object)lsee.getMessage());
                    throw new DecoderException("Invalid attribute type : " + lsee.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Adding type {}", (Object)type);
                }
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALS_TAG][49] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALS_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALS_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALS_VALUE][49] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALS_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_TAG, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_TAG][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_OR_ATTRIBUTE_OR_END][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_OR_ATTRIBUTE_OR_END, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_VALUE][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VAL_OR_ATTRIBUTE_OR_END, new GrammarAction("Store attribute value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddRequest addRequest = ldapMessage.getAddRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Object value = null;
                if (tlv.getLength().getLength() == 0) {
                    addRequest.addAttributeValue("");
                } else {
                    if (ldapMessageContainer.isBinary(addRequest.getCurrentAttributeType())) {
                        value = tlv.getValue().getData();
                        if (log.isDebugEnabled()) {
                            log.debug("Adding value {}", (Object)StringTools.dumpBytes(value));
                        }
                    } else {
                        value = StringTools.utf8ToString(tlv.getValue().getData());
                        log.debug("Adding value {}" + value);
                    }
                    addRequest.addAttributeValue(value);
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

