/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValue<T>
implements Value<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractValue.class);
    protected transient AttributeType attributeType;
    protected T wrappedValue;
    protected T normalizedValue;
    protected boolean normalized;
    protected Boolean valid;
    protected transient boolean same;

    @Override
    public Value<T> clone() {
        try {
            return (Value)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public T getReference() {
        return this.wrappedValue;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public void apply(AttributeType attributeType) {
        if (this.attributeType != null) {
            if (!attributeType.equals(this.attributeType)) {
                throw new IllegalArgumentException(I18n.err((String)"ERR_04476", (Object[])new Object[]{attributeType.getName(), this.attributeType.getName()}));
            }
            return;
        }
        this.attributeType = attributeType;
        try {
            this.normalize();
        }
        catch (LdapException ne) {
            String message = I18n.err((String)"ERR_04447", (Object[])new Object[]{ne.getLocalizedMessage()});
            LOG.info(message);
            this.normalized = false;
        }
    }

    protected LdapComparator<T> getLdapComparator() throws LdapException {
        if (this.attributeType != null) {
            MatchingRule mr = this.getMatchingRule();
            if (mr == null) {
                return null;
            }
            return mr.getLdapComparator();
        }
        return null;
    }

    protected MatchingRule getMatchingRule() throws LdapException {
        if (this.attributeType != null) {
            MatchingRule mr = this.attributeType.getEquality();
            if (mr == null) {
                mr = this.attributeType.getOrdering();
            }
            if (mr == null) {
                mr = this.attributeType.getSubstring();
            }
            return mr;
        }
        return null;
    }

    protected Normalizer getNormalizer() throws LdapException {
        if (this.attributeType != null) {
            MatchingRule mr = this.getMatchingRule();
            if (mr == null) {
                return null;
            }
            return mr.getNormalizer();
        }
        return null;
    }

    public boolean instanceOf(AttributeType attributeType) throws LdapException {
        if (attributeType != null && this.attributeType.equals(attributeType)) {
            if (this.attributeType.equals(attributeType)) {
                return true;
            }
            return this.attributeType.isDescendantOf(attributeType);
        }
        return false;
    }

    @Override
    public T getNormalizedValue() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            return this.get();
        }
        return this.getNormalizedValueCopy();
    }

    @Override
    public T getNormalizedValueReference() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            return this.wrappedValue;
        }
        return this.normalizedValue;
    }

    @Override
    public final boolean isNull() {
        return this.wrappedValue == null;
    }

    final boolean isSame() {
        return this.same;
    }

    @Override
    public final boolean isValid() {
        if (this.valid != null) {
            return this.valid;
        }
        this.valid = this.attributeType != null ? Boolean.valueOf(this.attributeType.getSyntax().getSyntaxChecker().isValidSyntax(this.get())) : Boolean.valueOf(false);
        return this.valid;
    }

    @Override
    public final boolean isValid(SyntaxChecker syntaxChecker) throws LdapException {
        if (syntaxChecker == null) {
            String message = I18n.err((String)"ERR_04139", (Object[])new Object[]{this.toString()});
            LOG.error(message);
            throw new LdapException(message);
        }
        this.valid = syntaxChecker.isValidSyntax(this.getReference());
        return this.valid;
    }

    @Override
    public void normalize() throws LdapException {
        this.normalized = true;
        this.normalizedValue = this.wrappedValue;
    }

    @Override
    public final boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public final void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }
}

