/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import org.apache.directory.shared.ldap.name.ComplexLdapDnParser;
import org.apache.directory.shared.ldap.name.FastLdapDnParser;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.name.TooComplexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LdapDnParser implements NameParser
{
    INSTANCE;


    public static NameParser getNameParser() {
        return INSTANCE;
    }

    public static void parseInternal(String name, List<Rdn> rdns) throws InvalidNameException {
        try {
            FastLdapDnParser.INSTANCE.parseDn(name, rdns);
        }
        catch (TooComplexException e) {
            rdns.clear();
            new ComplexLdapDnParser().parseDn(name, rdns);
        }
    }

    public static boolean validateInternal(String name) {
        LdapDN dn = new LdapDN();
        try {
            LdapDnParser.parseInternal(name, dn.rdns);
            return true;
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    @Override
    public Name parse(String dn) throws InvalidNameException {
        return new LdapDN(dn);
    }
}

